/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.beans.ConstructorProperties;
import java.util.Collections;
import lombok.NonNull;
import org.grade.engine.Results;
import org.grade.engine.Sandbox;
import org.grade.repo.Endpoint;
import org.grade.repo.QueryTarget;

public class ResultAdapter
implements Results {
    @NonNull
    private QueryTarget target;
    @NonNull
    private String graph;

    public static ResultAdapter adapt(@NonNull Sandbox box) {
        if (box == null) {
            throw new IllegalArgumentException("box is null");
        }
        return new ResultAdapter(box, box.graph());
    }

    public static ResultAdapter adapt(Endpoint ep, String graph) {
        return new ResultAdapter((QueryTarget)ep, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model get(int offset, int limit) {
        String exp = String.format("construct {?subject ?predicate ?object} where { graph <%s> {?subject ?predicate ?object}} OFFSET %s LIMIT %s", this.graph, offset, limit);
        QueryExecution execution = this.target.executionFor(QueryFactory.create((String)exp));
        try {
            Model model = execution.execConstruct();
            return model;
        }
        finally {
            if (Collections.singletonList(execution).get(0) != null) {
                execution.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model describe(String uri) {
        String exp = String.format("describe <%s>", uri);
        QueryExecution execution = this.target.executionFor(QueryFactory.create((String)exp));
        try {
            Model model = execution.execDescribe();
            return model;
        }
        finally {
            if (Collections.singletonList(execution).get(0) != null) {
                execution.close();
            }
        }
    }

    @ConstructorProperties(value={"target", "graph"})
    public ResultAdapter(@NonNull QueryTarget target, @NonNull String graph) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (graph == null) {
            throw new IllegalArgumentException("graph is null");
        }
        this.target = target;
        this.graph = graph;
    }
}

