/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.fao;

import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.fao.iMarineResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.retriever.ResultsRetriever;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FigisRetriever
implements ResultsRetriever {
    private final String url = "http://www.fao.org/fi/oldsite/eims_search/advanced_s_result.asp?querystring=";
    private String query;
    private ArrayList<SearchResult> results;
    ArrayList<iMarineResult> figisResults;
    private int desiredNumber;
    private HashMap<String, String> parameters;

    public FigisRetriever(String query, int desiredNumber) {
        this.query = query;
        this.desiredNumber = desiredNumber;
        this.results = new ArrayList();
        this.figisResults = new ArrayList();
        this.parameters = new HashMap();
    }

    public void retrieveResults() {
        try {
            if (this.desiredNumber <= 0) {
                this.desiredNumber = Resources.MAX_NUM_OF_RESULTS_FROM_WSE;
            }
            String enc_query = URLEncoder.encode(this.query.trim(), "utf-8");
            String queryPath = "http://www.fao.org/fi/oldsite/eims_search/advanced_s_result.asp?querystring=" + enc_query;
            if (!this.parameters.isEmpty()) {
                String paramsString = "";
                for (String paramKey : this.parameters.keySet()) {
                    String paramValue = (String)this.parameters.get(paramKey);
                    paramsString = paramsString + "&" + paramKey + "=" + paramValue;
                }
                queryPath = queryPath + paramsString;
            }
            System.out.println("QUERY PATH: " + queryPath);
            URL theurl = new URL(queryPath);
            HTMLTag tagger1 = new HTMLTag(theurl, true);
            int n = tagger1.getFirstTagIndex("publication");
            int num = 0;
            while (n != -1) {
                iMarineResult marineResult = new iMarineResult();
                SearchResult result = new SearchResult();
                result.setRank(num);
                String pub_id = tagger1.getFirstTagContent("publication", n - 1);
                pub_id = this.getIdAttribute(pub_id);
                marineResult.setId(pub_id);
                String pub_data = tagger1.getFirstTagData("publication", n - 1);
                HTMLTag tagger2 = new HTMLTag(pub_data);
                HashSet<String> languages = new HashSet<String>();
                String lan = tagger2.getFirstTagData("dc:language");
                String[] langs = lan.split("/");
                languages.addAll(Arrays.asList(langs));
                marineResult.setLanguages(languages);
                String type = tagger2.getFirstTagData("dc:type");
                marineResult.setType(type);
                String creator = tagger2.getFirstTagData("dc:creator");
                marineResult.setCreator(creator);
                HashMap<String, String> titles = new HashMap<String, String>();
                String titleSupplement = "";
                int i = tagger2.getFirstTagIndex("dc:title");
                while (i != -1) {
                    String lang;
                    String title_attr = tagger2.getFirstTagContent("dc:title", i - 1);
                    String title_cont = tagger2.getFirstTagData("dc:title", i - 1);
                    if (title_cont == null) {
                        title_cont = "";
                    }
                    if (title_cont.contains("ags:titleSupplement")) {
                        titleSupplement = tagger2.getFirstTagData("ags:titleSupplement");
                    }
                    if ((lang = this.getLangAttribute(title_attr)).toLowerCase().equals("en") && !title_cont.contains("ags:titleSupplement")) {
                        result.setTitle(title_cont);
                    }
                    titles.put(lang, title_cont);
                    i = tagger2.getFirstTagIndex("dc:title", i + 2);
                }
                marineResult.setTitles(titles);
                marineResult.setTitleSupplement(titleSupplement);
                if (!result.getTitle().trim().equals("")) {
                    result.setTitle(type + " (" + pub_id + ") - " + result.getTitle());
                } else {
                    result.setTitle(type + " (" + pub_id + ")");
                }
                HashMap<String, String> descriptions = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("dcterms:abstract");
                while (i != -1) {
                    String lang;
                    String descr_attr = tagger2.getFirstTagContent("dcterms:abstract", i - 1);
                    String descr_cont = tagger2.getFirstTagData("dcterms:abstract", i - 1);
                    if (descr_cont == null) {
                        descr_cont = "";
                    }
                    if ((lang = this.getLangAttribute(descr_attr)).toLowerCase().equals("en")) {
                        result.setDescription(descr_cont);
                    }
                    descriptions.put(lang, descr_cont);
                    i = tagger2.getFirstTagIndex("dcterms:abstract", i + 2);
                }
                marineResult.setDescriptions(descriptions);
                String pages = tagger2.getFirstTagData("pages");
                if (pages == null) {
                    pages = "-";
                }
                if (pages.equals("")) {
                    pages = "-";
                }
                marineResult.setPages(pages);
                HashMap<String, String> identifiers = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("dc:identifier");
                while (i != -1) {
                    String ident_attr = tagger2.getFirstTagContent("dc:identifier", i - 1);
                    String ident_cont = tagger2.getFirstTagData("dc:identifier", i - 1);
                    String scheme = this.getSchemeAttribute(ident_attr);
                    identifiers.put(scheme, ident_cont);
                    i = tagger2.getFirstTagIndex("dc:identifier", i + 2);
                }
                if (identifiers.containsKey("URI")) {
                    result.setUrl((String)identifiers.get("URI"));
                } else if (identifiers.containsKey("PDF_URI")) {
                    result.setUrl((String)identifiers.get("PDF_URI"));
                } else if (identifiers.isEmpty()) {
                    result.setUrl("{-}");
                } else {
                    result.setUrl(identifiers.toString());
                }
                HashMap<String, String> dates = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("dc:date");
                while (i != -1) {
                    String date_attr = tagger2.getFirstTagContent("dc:date", i - 1);
                    String date_cont = tagger2.getFirstTagData("dc:date", i - 1);
                    String scheme = this.getSchemeAttribute(date_attr);
                    dates.put(scheme, date_cont);
                    i = tagger2.getFirstTagIndex("dc:date", i + 2);
                }
                marineResult.setDates(dates);
                HashMap<String, String> isPartOf = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("dcterms:isPartOf");
                while (i != -1) {
                    String part_attr = tagger2.getFirstTagContent("dcterms:isPartOf", i - 1);
                    String part_cont = tagger2.getFirstTagData("dcterms:isPartOf", i - 1);
                    String lang = this.getLangAttribute(part_attr);
                    isPartOf.put(lang, part_cont);
                    i = tagger2.getFirstTagIndex("dcterms:isPartOf", i + 2);
                }
                marineResult.setIsPartOf(isPartOf);
                HashMap<Integer, String> hasVersion = new HashMap<Integer, String>();
                i = tagger2.getFirstTagIndex("dcterms:hasVersion");
                while (i != -1) {
                    String ver_attr = tagger2.getFirstTagContent("dcterms:hasVersion", i - 1);
                    String ver_cont = tagger2.getFirstTagData("dcterms:hasVersion", i - 1);
                    String infotypeStr = this.getInfotypeAttribute(ver_attr);
                    int infotype = -1;
                    if (infotypeStr != null) {
                        try {
                            infotype = Integer.parseInt(infotypeStr);
                        }
                        catch (Exception e) {
                            IOSLog.writeErrorToLog((Exception)e, (String)"FigisRetriever 2");
                            infotype = -1;
                        }
                    }
                    hasVersion.put(infotype, ver_cont);
                    i = tagger2.getFirstTagIndex("dcterms:hasVersion", i + 2);
                }
                marineResult.setHasVersion(hasVersion);
                String department = tagger2.getFirstTagData("department");
                marineResult.setDepartment(department);
                String division = tagger2.getFirstTagData("division");
                marineResult.setDevision(division);
                String notes = tagger2.getFirstTagData("notes");
                marineResult.setNotes(notes);
                if (notes != null) {
                    result.setDescription(result.getDescription() + " - " + notes);
                }
                result.setContent(result.getTitle() + " " + result.getDescription());
                if (result.getContent().trim().equals("")) {
                    result.setContent("- - -");
                }
                HashMap<String, String> subjectThesaurus = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("ags:subjectThesaurus");
                while (i != -1) {
                    String sub_attr = tagger2.getFirstTagContent("ags:subjectThesaurus", i - 1);
                    String sub_cont = tagger2.getFirstTagData("ags:subjectThesaurus", i - 1);
                    String scheme = this.getSchemeAttribute(sub_attr);
                    String s_id = this.getIdAttribute(sub_attr);
                    subjectThesaurus.put(scheme + "-" + s_id, sub_cont);
                    i = tagger2.getFirstTagIndex("ags:subjectThesaurus", i + 2);
                }
                marineResult.setSubjectThesaurus(subjectThesaurus);
                HashMap<String, String> subjectClassifications = new HashMap<String, String>();
                i = tagger2.getFirstTagIndex("ags:subjectClassification");
                while (i != -1) {
                    String sub_attr = tagger2.getFirstTagContent("ags:subjectClassification", i - 1);
                    String sub_cont = tagger2.getFirstTagData("ags:subjectClassification", i - 1);
                    String scheme = this.getSchemeAttribute(sub_attr);
                    subjectClassifications.put(scheme, sub_cont);
                    i = tagger2.getFirstTagIndex("ags:subjectClassification", i + 2);
                }
                marineResult.setSubjectClassification(subjectClassifications);
                this.figisResults.add(marineResult);
                this.results.add(result);
                if (++num != this.desiredNumber) {
                    n = tagger1.getFirstTagIndex("publication", n + 2);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            IOSLog.writeErrorToLog((Exception)ex, (String)"FigisRetriever 3");
            System.out.println("*** COULD NOT RETRIEVE RESULTS FROM iMarine!");
            Logger.getLogger(FigisRetriever.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getInfotypeAttribute(String attr) {
        String infot = "";
        attr = attr.toUpperCase();
        int i = attr.indexOf("INFOTYPE=");
        int j = attr.indexOf("\"", i + 1);
        int k = attr.indexOf("\"", j + 1);
        infot = attr.substring(j + 1, k);
        return infot;
    }

    private String getSchemeAttribute(String attr) {
        String scheme = "";
        attr = attr.toUpperCase();
        int i = attr.indexOf("SCHEME=");
        int j = attr.indexOf("\"", i + 1);
        int k = attr.indexOf("\"", j + 1);
        scheme = attr.substring(j + 1, k);
        return scheme;
    }

    private String getIdAttribute(String attr) {
        String scheme = "";
        attr = attr.toUpperCase();
        int i = attr.indexOf("ID=");
        int j = attr.indexOf("\"", i + 1);
        int k = attr.indexOf("\"", j + 1);
        scheme = attr.substring(j + 1, k);
        return scheme;
    }

    private String getLangAttribute(String attr) {
        String lang = "";
        attr = attr.toUpperCase();
        int i = attr.indexOf("XML:LANG=");
        int j = attr.indexOf("\"", i + 1);
        int k = attr.indexOf("\"", j + 1);
        lang = attr.substring(j + 1, k);
        return lang;
    }

    public ArrayList<SearchResult> getResults() {
        return this.results;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setDesiredNumber(int desiredNumber) {
        this.desiredNumber = desiredNumber;
    }

    public int getDesiredNumber() {
        return this.desiredNumber;
    }

    public ArrayList<iMarineResult> getFigisResults() {
        return this.figisResults;
    }

    public void setFigisResults(ArrayList<iMarineResult> figisResults) {
        this.figisResults = figisResults;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return "http://www.fao.org/fi/oldsite/eims_search/advanced_s_result.asp?querystring=";
    }

    public void setResults(ArrayList<SearchResult> results) {
        this.results = results;
    }
}

