/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class FileDownloader {
    private final int bufferSize = 153600;
    private final String tarSuffix = ".tar.gz";

    public FileDownloader download(String getFrom, String storeTo) {
        this.getClass();
        byte[] buffer = new byte[153600];
        int bytesRead = 0;
        try {
            URL url = new URL(getFrom);
            url.openConnection();
            InputStream inStream = url.openStream();
            FileOutputStream outStream = new FileOutputStream(storeTo);
            while ((bytesRead = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, bytesRead);
                this.getClass();
                buffer = new byte[153600];
            }
            outStream.close();
            inStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public FileDownloader decompress(String rarFile, String destFold) {
        try {
            File dest = new File(destFold);
            dest.mkdir();
            TarInputStream tin = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(new File(rarFile))));
            TarEntry tarEntry = tin.getNextEntry();
            while (tarEntry != null) {
                File destPath = new File(dest.toString() + File.separatorChar + tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    destPath.mkdir();
                } else {
                    FileOutputStream fout = new FileOutputStream(destPath);
                    tin.copyEntryContents((OutputStream)fout);
                    fout.close();
                }
                tarEntry = tin.getNextEntry();
            }
            tin.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public static void main(String[] args) {
        String preUrl = "http://svn.research-infrastructures.eu/public/d4science/gcube/trunk/semantic-search/XSearch-Service-conf/";
        String prePath = "C:/Downloader/";
        String xsearchProperties = "x-search.properties";
        String miningProperties = "mining.properties";
        String clusteringProperties = "clustering.properties";
        String confFiles = "XSearch-Service-conf.tar.gz";
        new FileDownloader().download(preUrl + clusteringProperties, prePath + clusteringProperties).download(preUrl + miningProperties, prePath + miningProperties).download(preUrl + xsearchProperties, prePath + xsearchProperties).download(preUrl + confFiles, prePath + confFiles).decompress(prePath + confFiles, prePath);
    }
}

