/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesSearchForm;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.resources.Resources;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.Util;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.CommonName;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Coordinate;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.SearchFilters;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Taxon;

public class SpeciesSearchForm
extends ContentPanel {
    protected static final String TOGGLE_CLASS = "SPECIES_TOGGLE";
    protected static final String COMMON_NAME = "Common name";
    protected static final String SCIENTIFIC_NAME = "Scientific name";
    protected Button searchButton;
    protected ListStore<ModelData> store;
    protected Image loadingImage;
    protected HTML resultCounter = new HTML();
    protected SimpleComboBox<String> searchType;

    public SpeciesSearchForm(ListStore<ModelData> store) {
        this.setLayout((Layout)new AnchorLayout());
        this.setFrame(false);
        this.setHeaderVisible(false);
        this.setHeight(100);
        this.store = store;
        FormPanel searchPanel = new FormPanel();
        searchPanel.setHeaderVisible(false);
        searchPanel.setBorders(false);
        searchPanel.setLabelWidth(100);
        FormData formData = new FormData("100%");
        LayoutContainer main = new LayoutContainer();
        main.setLayout((Layout)new ColumnLayout());
        LayoutContainer left = new LayoutContainer();
        left.setStyleAttribute("paddingRight", "10px");
        FormLayout layout = new FormLayout();
        left.setLayout((Layout)layout);
        NumberField upperBoundLatitudeField = new NumberField();
        upperBoundLatitudeField.setPropertyEditorType(Float.class);
        upperBoundLatitudeField.setEmptyText("Latitude");
        NumberField upperBoundLongitudeField = new NumberField();
        upperBoundLongitudeField.setPropertyEditorType(Float.class);
        upperBoundLongitudeField.setEmptyText("Longitude");
        MultiField uppertBound = new MultiField("Upper Bound", new Field[]{upperBoundLatitudeField, upperBoundLongitudeField});
        left.add((Widget)uppertBound, (LayoutData)formData);
        NumberField lowerBoundLatitudeField = new NumberField();
        lowerBoundLatitudeField.setPropertyEditorType(Float.class);
        lowerBoundLatitudeField.setEmptyText("Latitude");
        NumberField lowerBoundLongitudeField = new NumberField();
        lowerBoundLongitudeField.setPropertyEditorType(Float.class);
        lowerBoundLongitudeField.setEmptyText("Longitude");
        MultiField lowerBound = new MultiField("Lower Bound", new Field[]{lowerBoundLatitudeField, lowerBoundLongitudeField});
        left.add((Widget)lowerBound, (LayoutData)formData);
        LayoutContainer right = new LayoutContainer();
        right.setStyleAttribute("paddingLeft", "10px");
        layout = new FormLayout();
        right.setLayout((Layout)layout);
        DateField fromDate = new DateField();
        fromDate.setEmptyText("From");
        DateField toDate = new DateField();
        toDate.setEmptyText("To");
        MultiField dateField = new MultiField("Date bounds", new Field[]{fromDate, toDate});
        right.add((Widget)dateField, (LayoutData)formData);
        main.add((Widget)left, (LayoutData)new ColumnData(0.5));
        main.add((Widget)right, (LayoutData)new ColumnData(0.5));
        searchPanel.add((Widget)main, (LayoutData)new FormData("45%"));
        HorizontalPanel namePanel = new HorizontalPanel();
        namePanel.setSpacing(5);
        this.searchType = new SimpleComboBox();
        this.searchType.add(Arrays.asList(SCIENTIFIC_NAME, COMMON_NAME));
        this.searchType.setEditable(false);
        this.searchType.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.searchType.setSimpleValue((Object)SCIENTIFIC_NAME);
        namePanel.add((Widget)this.searchType);
        namePanel.add((Widget)new Label(":"));
        TextField searchField = new TextField();
        searchField.setWidth(200);
        namePanel.add((Widget)searchField);
        this.searchButton = new Button("Search");
        namePanel.add((Widget)this.searchButton);
        namePanel.add((Widget)new Button("Example", (SelectionListener)new /* Unavailable Anonymous Inner Class!! */));
        this.loadingImage = new Image(Resources.INSTANCE.loadingBalls());
        this.loadingImage.setVisible(false);
        namePanel.add((Widget)this.loadingImage);
        namePanel.add((Widget)this.resultCounter);
        searchPanel.add((Widget)namePanel, (LayoutData)new AnchorData("100%"));
        this.add((Widget)searchPanel, (LayoutData)new AnchorData("100%"));
        this.searchButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void search(String searchTerm, Number upperBoundLongitude, Number upperBoundLatitude, Number lowerBoundLongitude, Number lowerBoundLatitude, Date fromDate, Date toDate) {
        this.mask("Searching...");
        this.searchButton.setEnabled(false);
        this.resultCounter.setHTML("");
        this.store.removeAll();
        3 callback = new /* Unavailable Anonymous Inner Class!! */;
        Coordinate upperCoordinate = upperBoundLatitude != null && upperBoundLongitude != null ? new Coordinate(upperBoundLatitude.floatValue(), upperBoundLongitude.floatValue()) : null;
        Coordinate lowerCoordinate = lowerBoundLatitude != null && lowerBoundLongitude != null ? new Coordinate(lowerBoundLatitude.floatValue(), lowerBoundLongitude.floatValue()) : null;
        SearchFilters filters = new SearchFilters(upperCoordinate, lowerCoordinate, fromDate, toDate);
        if (SCIENTIFIC_NAME.equals(this.searchType.getSimpleValue())) {
            SpeciesDiscovery.taxonomySearchService.searchByScientificName(searchTerm, filters, (AsyncCallback)callback);
        }
        if (COMMON_NAME.equals(this.searchType.getSimpleValue())) {
            SpeciesDiscovery.taxonomySearchService.searchByCommonName(searchTerm, filters, (AsyncCallback)callback);
        }
    }

    protected void getSearchData(String searchId) {
        SpeciesDiscovery.taxonomySearchService.getResultRow(searchId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void loadData(ArrayList<ResultRow> rows) {
        for (ResultRow row : rows) {
            BaseModelData data = this.convertResultRow(row);
            this.store.add((ModelData)data);
        }
        this.resultCounter.setHTML(String.valueOf(this.store.getCount()) + " results");
    }

    protected void enableSearch() {
        this.loadingImage.setVisible(false);
        this.searchButton.setEnabled(true);
    }

    protected void disableSearch() {
        this.loadingImage.setVisible(true);
        this.searchButton.setEnabled(false);
    }

    protected BaseModelData convertResultRow(ResultRow row) {
        BaseModelData data = new BaseModelData();
        data.set(SpeciesGridFields.DATASOURCE.getId(), (Object)row.getDataSourceName());
        data.set(SpeciesGridFields.DATAPROVIDER.getId(), (Object)row.getDataProviderName());
        data.set(SpeciesGridFields.DATASET.getId(), (Object)row.getDataSetName());
        data.set(SpeciesGridFields.DATASET_CITATION.getId(), (Object)row.getDataSetCitation());
        data.set(SpeciesGridFields.MATCHING_NAME.getId(), (Object)row.getMatchingTaxon().getName());
        data.set(SpeciesGridFields.MATCHING_AUTHOR.getId(), (Object)row.getMatchingTaxon().getAccordingTo());
        data.set(SpeciesGridFields.MATCHING_RANK.getId(), (Object)row.getMatchingTaxon().getRank());
        data.set(SpeciesGridFields.MATCHING_CREDITS.getId(), (Object)row.getMatchingCredits());
        data.set(SpeciesGridFields.PRODUCT_IMAGES.getId(), (Object)row.getImagesCount());
        data.set(SpeciesGridFields.PRODUCT_MAPS.getId(), (Object)row.getMapsCount());
        data.set(SpeciesGridFields.PRODUCT_LAYERS.getId(), (Object)row.getLayersCount());
        data.set(SpeciesGridFields.PRODUCT_OCCURRENCES.getId(), (Object)row.getOccurencesCount());
        data.set(SpeciesGridFields.PRODUCT_SPECIMENS.getId(), (Object)row.getSpeciementsCount());
        String classificationString = this.getClassification(row.getMatchingTaxon());
        data.set(SpeciesGridFields.CLASSIFICATION_STRING.getId(), (Object)classificationString);
        String rankHTML = this.getRankHtml(row.getMatchingTaxon());
        data.set(SpeciesGridFields.TAXON.getId(), (Object)rankHTML);
        String commonNames = this.getCommonNamesHTML(row.getMatchingTaxon().getName(), row.getMatchingTaxon().getAccordingTo(), row.getMatchingCredits(), (List)row.getCommonNames());
        data.set(SpeciesGridFields.COMMON_NAMES.getId(), (Object)commonNames);
        String provenance = this.getProvenanceHTML(row.getDataSourceName(), row.getDataProviderName(), row.getDataSetName(), row.getDataSetCitation());
        data.set(SpeciesGridFields.PROVENANCE.getId(), (Object)provenance);
        String products = this.getProdutcsHTML(row.getImagesCount(), row.getMapsCount(), row.getLayersCount(), row.getOccurencesCount(), row.getSpeciementsCount());
        data.set(SpeciesGridFields.PRODUCTS.getId(), (Object)products);
        data.set(SpeciesGridFields.ROW.getId(), (Object)row);
        return data;
    }

    protected String getRankHtml(Taxon taxon) {
        String id = Document.get().createUniqueId();
        StringBuilder html = new StringBuilder("<p><br/>");
        int offset = html.length();
        html.append("<table id=\"");
        html.append(id);
        html.append("\">");
        boolean addToggler = false;
        do {
            if (!Util.isMainTaxonomicRank((String)taxon.getRank())) {
                html.append("<tr class=\"");
                html.append(TOGGLE_CLASS);
                html.append("\" style=\"display:none\"><td><b>");
                addToggler = true;
            } else {
                html.append("<tr><td><b>");
            }
            html.append(taxon.getRank());
            html.append(":</b></td><td>{");
            html.append(taxon.getName());
            html.append("}</td></tr>");
        } while ((taxon = taxon.getParent()) != null);
        html.append("</table>");
        if (addToggler) {
            StringBuilder toggler = new StringBuilder();
            String idImgExpand = Document.get().createUniqueId();
            String idImgCollapse = Document.get().createUniqueId();
            toggler.append("<a href=\"#\" onclick=\"toggle('");
            toggler.append(TOGGLE_CLASS);
            toggler.append("','");
            toggler.append(id);
            toggler.append("','tr');toggleSingle('");
            toggler.append(idImgExpand);
            toggler.append("');toggleSingle('");
            toggler.append(idImgCollapse);
            toggler.append("')\">");
            toggler.append("<img id=\"");
            toggler.append(idImgExpand);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getExpand().getSafeUri().asString());
            toggler.append("\" style=\"float:left;\" />");
            toggler.append("<img id=\"");
            toggler.append(idImgCollapse);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getCollapse().getSafeUri().asString());
            toggler.append("\" style=\"float:left;display:none\" />");
            toggler.append("</a>");
            html.insert(offset, toggler.toString());
        } else {
            html.insert(offset, "<div style=\"padding-left:" + Resources.INSTANCE.getExpand().getWidth() + "px\">");
            html.append("</div>");
        }
        html.append("</p>");
        return html.toString();
    }

    protected String getCommonNamesHTML(String scientificName, String author, String credits, List<CommonName> commonNames) {
        StringBuilder html = new StringBuilder("<p><h1 style=\"color: #385F95;\">");
        html.append(scientificName);
        html.append("</h1>");
        if (commonNames.size() > 0) {
            html.append("aka : ");
        }
        html.append("<table>");
        HashSet<String> insertedLanguages = new HashSet<String>();
        for (CommonName commonName : commonNames) {
            if (insertedLanguages.contains(commonName.getLanguage())) continue;
            insertedLanguages.add(commonName.getLanguage());
            html.append("<tr><td><b>");
            html.append(commonName.getLanguage());
            html.append(":</b></td><td>");
            html.append(commonName.getName());
            html.append("</td></tr>");
        }
        html.append("<tr></tr>");
        html.append("<tr><td><b>Inserted by: </b></td><td>");
        html.append(author);
        html.append("</td></tr>");
        html.append("<tr><td><b>Credits: </b></td><td>");
        html.append(credits);
        html.append("</td></tr>");
        html.append("</table>");
        html.append("</p>");
        return html.toString();
    }

    protected String getProvenanceHTML(String datasource, String dataprovider, String dataset, String datasetCitation) {
        StringBuilder html = new StringBuilder("<p><br/><table>");
        html.append("<tr><td><b>Data Source:</b></td><td>");
        html.append(datasource);
        html.append("</td></tr>");
        html.append("<tr><td><b>Data Provider:</b></td><td>");
        html.append(dataprovider);
        html.append("</td></tr>");
        html.append("<tr><td><b>Data Set:</b></td><td>");
        html.append(dataset);
        html.append("</td></tr>");
        html.append("<tr><td><b>Citation:</b></td><td>");
        html.append(datasetCitation);
        html.append("</td></tr>");
        html.append("</table></p>");
        return html.toString();
    }

    protected String getProdutcsHTML(int imagesCount, int mapCounts, int layersCount, int occurencesCount, int speciementsCount) {
        StringBuilder html = new StringBuilder("<p><br/><table>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_IMAGES.getName());
        html.append(":</b></td><td>");
        html.append(imagesCount);
        html.append("</td></tr>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_MAPS.getName());
        html.append(":</b></td><td>");
        html.append(mapCounts);
        html.append("</td></tr>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_LAYERS.getName());
        html.append(":</b></td><td>");
        html.append(layersCount);
        html.append("</td></tr>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_OCCURRENCES.getName());
        html.append(":</b></td><td>");
        html.append(occurencesCount);
        html.append("</td></tr>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_SPECIMENS.getName());
        html.append(":</b></td><td>");
        html.append(speciementsCount);
        html.append("</td></tr>");
        html.append("</table></p>");
        return html.toString();
    }

    protected String getClassification(Taxon taxon) {
        StringBuilder sb = new StringBuilder();
        if (taxon.getParent() != null) {
            sb.append(this.getClassification(taxon.getParent()));
            sb.append(" -> ");
        }
        sb.append("<b>");
        sb.append(taxon.getRank());
        sb.append("</b>: ");
        sb.append(taxon.getName());
        return sb.toString();
    }
}

