/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.DescriptiveSpeciesGrid;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.OccurrencesWindow;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesGrid;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesThumbsView;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesView;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.resources.Resources;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.gcubegisviewer.client.GCubeGisViewer;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveHandler;
import org.gcube.portlets.user.gisviewer.client.GisViewerParameters;
import org.gcube.portlets.user.workspace.lighttree.client.ItemType;
import org.gcube.portlets.user.workspace.lighttree.client.event.DataLoadHandler;
import org.gcube.portlets.user.workspace.lighttree.client.event.PopupHandler;
import org.gcube.portlets.user.workspace.lighttree.client.save.WorkspaceLightTreeSavePopup;

public class SpeciesResultsPanel
extends ContentPanel {
    protected static final String TOGGLE_GROUP = "SPECIES_VIEW";
    private static SpeciesResultsPanel instance;
    protected final SpeciesGrid classicGridView;
    protected final DescriptiveSpeciesGrid descriptiveGridView;
    protected final SpeciesThumbsView imageGridView;
    protected SpeciesView currentView;
    protected ToggleButton classicGridViewButton;
    protected ToggleButton descriptiveGridViewButton;
    private ToggleButton imageGridViewButton;
    protected Button actionButton;

    public static SpeciesResultsPanel getInstance() {
        return instance;
    }

    public SpeciesResultsPanel(ListStore<ModelData> store) {
        instance = this;
        this.setFrame(false);
        this.setCollapsible(false);
        this.setAnimCollapse(false);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new AnchorLayout());
        this.setScrollMode(Style.Scroll.AUTOX);
        this.classicGridView = new SpeciesGrid(store);
        this.descriptiveGridView = new DescriptiveSpeciesGrid(store);
        this.imageGridView = new SpeciesThumbsView(store, 86);
        ToolBar toolBar = new ToolBar();
        LabelToolItem labelView = new LabelToolItem("Switch view : ");
        toolBar.add((Component)labelView);
        this.classicGridViewButton = new ToggleButton("", AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGridSpeciesIcon()));
        this.classicGridViewButton.setToggleGroup(TOGGLE_GROUP);
        this.classicGridViewButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.classicGridViewButton.setAllowDepress(false);
        this.classicGridViewButton.setToolTip(new ToolTipConfig("Scientific view", "Shows filtered species as a basic grid"));
        toolBar.add((Component)this.classicGridViewButton);
        this.descriptiveGridViewButton = new ToggleButton("", AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getDescriptiveSpeciesIcon()));
        this.descriptiveGridViewButton.setToggleGroup(TOGGLE_GROUP);
        this.descriptiveGridViewButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.descriptiveGridViewButton.setAllowDepress(false);
        this.descriptiveGridViewButton.setToolTip(new ToolTipConfig("Expandable List view", "Shows filtered species as a grid letting users to expand interested rows."));
        toolBar.add((Component)this.descriptiveGridViewButton);
        this.imageGridViewButton = new ToggleButton("", AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGridImagesIcon()));
        this.imageGridViewButton.setToggleGroup(TOGGLE_GROUP);
        this.imageGridViewButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.imageGridViewButton.setAllowDepress(false);
        this.imageGridViewButton.setToolTip(new ToolTipConfig("Images view", "Shows filtered species images and details on selected."));
        toolBar.add((Component)this.imageGridViewButton);
        toolBar.add((Component)new SeparatorToolItem());
        this.actionButton = new Button("Actions");
        toolBar.add((Component)this.actionButton);
        Menu actionMenu = new Menu();
        this.actionButton.setMenu(actionMenu);
        MenuItem occurrencesMenuItem = new MenuItem(SpeciesGridFields.PRODUCT_OCCURRENCES.getName());
        actionMenu.add((Component)occurrencesMenuItem);
        Menu occurencesMenu = new Menu();
        occurrencesMenuItem.setSubMenu(occurencesMenu);
        MenuItem showItem = new MenuItem("Show Occurrences");
        showItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getShowProducts()));
        showItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        showItem.setToolTip(new ToolTipConfig("Show Occurrences", "Shows occurences points from selected results."));
        occurencesMenu.add((Component)showItem);
        MenuItem saveItem = new MenuItem("Save Occurrences");
        saveItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        saveItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        saveItem.setToolTip(new ToolTipConfig("Save Occurrences", "Save occurences points from selected results."));
        occurencesMenu.add((Component)saveItem);
        MenuItem mapItem = new MenuItem("Show in GisViewer");
        mapItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGisProducts()));
        mapItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        mapItem.setToolTip(new ToolTipConfig("Show in Gis Viewer", "Show occurences points from selected results in a Gis Viewer Map."));
        occurencesMenu.add((Component)mapItem);
        actionMenu.add((Component)this.getMenu(SpeciesGridFields.PRODUCT_IMAGES.getName(), true, true, false));
        actionMenu.add((Component)this.getMenu(SpeciesGridFields.PRODUCT_MAPS.getName(), true, true, true));
        actionMenu.add((Component)this.getMenu(SpeciesGridFields.PRODUCT_LAYERS.getName(), true, true, true));
        actionMenu.add((Component)this.getMenu(SpeciesGridFields.PRODUCT_SPECIMENS.getName(), true, true, true));
        this.add((Widget)this.classicGridView, (LayoutData)new AnchorData("100% 100%"));
        this.add((Widget)this.descriptiveGridView, (LayoutData)new AnchorData("100% 100%"));
        this.add((Widget)this.imageGridView, (LayoutData)new AnchorData("100% 100%"));
        this.setTopComponent((Component)toolBar);
        this.toggleView((SpeciesView)this.classicGridView);
    }

    protected MenuItem getMenu(String label, boolean show, boolean save, boolean gis) {
        MenuItem mainMenuItem = new MenuItem(label);
        Menu subMenu = new Menu();
        mainMenuItem.setSubMenu(subMenu);
        if (show) {
            MenuItem showItem = new MenuItem("Show " + label);
            showItem.setToolTip(new ToolTipConfig("Show " + label));
            showItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getShowProducts()));
            subMenu.add((Component)showItem);
        }
        if (save) {
            MenuItem saveItem = new MenuItem("Save " + label);
            saveItem.setToolTip(new ToolTipConfig("Save " + label));
            saveItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
            subMenu.add((Component)saveItem);
        }
        if (gis) {
            MenuItem mapItem = new MenuItem("Show in GisViewer");
            mapItem.setToolTip(new ToolTipConfig("Show in Gis Viewer"));
            mapItem.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGisProducts()));
            subMenu.add((Component)mapItem);
        }
        return mainMenuItem;
    }

    protected void toggleView(SpeciesView view) {
        instance.mask("Switching view..");
        this.actionButton.setEnabled(false);
        if (view.equals(this.classicGridView)) {
            this.classicGridViewButton.toggle(true);
            this.classicGridView.show();
            this.actionButton.setEnabled(true);
        } else {
            this.classicGridViewButton.toggle(false);
            this.classicGridView.hide();
        }
        if (view.equals(this.descriptiveGridView)) {
            this.descriptiveGridViewButton.toggle(true);
            this.descriptiveGridView.show();
            this.actionButton.setEnabled(true);
        } else {
            this.descriptiveGridViewButton.toggle(false);
            this.descriptiveGridView.hide();
        }
        if (view.equals(this.imageGridView)) {
            this.imageGridViewButton.toggle(true);
            this.imageGridView.show();
        } else {
            this.imageGridViewButton.toggle(false);
            this.imageGridView.hide();
        }
        this.currentView = view;
        instance.unmask();
    }

    protected void onAfterLayout() {
        super.onAfterLayout();
        this.descriptiveGridView.layout();
        this.imageGridView.layout();
        this.reload();
    }

    public void openOccurenceWindow() {
        OccurrencesWindow occurencesWindow = new OccurrencesWindow();
        occurencesWindow.show();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveOccurences() {
        WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Occurrence points", true, "Occurrences.csv");
        popup.setSelectableTypes(new ItemType[]{ItemType.FOLDER, ItemType.ROOT});
        popup.center();
        popup.addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addDataLoadHandler((DataLoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    public void showOccurrencesMap() {
        MessageBox progress = MessageBox.wait((String)"Generating map", (String)"Calculating occurrence points", (String)"generating...");
        List selectedRows = this.currentView.getSelectedRows();
        System.out.println("Selected " + selectedRows.size() + " rows");
        LinkedList<String> keys = new LinkedList<String>();
        int count = 0;
        for (ResultRow row : selectedRows) {
            if (row.getOccurencesCount() <= 0) continue;
            keys.add(row.getOccurencesKey());
            count += row.getOccurencesCount();
        }
        System.out.println("Filtered " + keys.size() + " keys");
        progress.updateText("Generating GIS map from " + count + " occurrence points");
        SpeciesDiscovery.taxonomySearchService.generateMapFromOccurrences(keys, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showMap(String groupName) {
        GisViewerParameters gisViewerParameters = new GisViewerParameters();
        gisViewerParameters.setOpeningGroup(groupName);
        GCubeGisViewer gisViewer = new GCubeGisViewer(gisViewerParameters);
        gisViewer.addSaveHandler((SaveHandler)new /* Unavailable Anonymous Inner Class!! */);
        gisViewer.setMaskOnSaveEvents();
        gisViewer.show();
    }

    public void reload() {
        if (this.currentView != null) {
            this.currentView.reload();
        }
    }
}

