/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Status;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Occurrence;

public class OccurrencesWindow
extends Window {
    protected GroupingStore<BaseModelData> store;
    protected int count = 0;
    protected Status status;

    public OccurrencesWindow() {
        this.setHeading("Occurrence points");
        this.setLayout((Layout)new FitLayout());
        this.setModal(true);
        this.setResizable(true);
        this.setSize(1200, 500);
        this.store = new GroupingStore();
        ColumnConfig latitudeColumn = new ColumnConfig("latitude", "Latitude", 150);
        ColumnConfig longitudeColumn = new ColumnConfig("longitude", "Longitude", 150);
        ColumnConfig catalogNumberColumn = new ColumnConfig("catalogNumber", "Catalog Number", 150);
        ColumnConfig countryColumn = new ColumnConfig("country", "Country", 150);
        ColumnConfig earliestDateCollectedColumn = new ColumnConfig("earliestDateCollected", "Earliest Date Collected", 150);
        ColumnConfig latestDateCollectedColumn = new ColumnConfig("latestDateCollected", "Latest Date Collected", 150);
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        config.add(latitudeColumn);
        config.add(longitudeColumn);
        config.add(catalogNumberColumn);
        config.add(countryColumn);
        config.add(earliestDateCollectedColumn);
        config.add(latestDateCollectedColumn);
        ColumnModel cm = new ColumnModel(config);
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        Grid grid = new Grid((ListStore)this.store, cm);
        grid.setView((GridView)view);
        grid.setBorders(true);
        ToolBar statusBar = new ToolBar();
        statusBar.add((Component)new FillToolItem());
        this.status = new Status();
        statusBar.add((Component)this.status);
        this.setBottomComponent((Component)statusBar);
        this.add((Component)grid);
    }

    public void loadOccurences(List<String> keys, int count) {
        if (keys.size() == 0) {
            return;
        }
        this.status.setBusy("loading 0 of " + count);
        this.count = count;
        this.store.removeAll();
        SpeciesDiscovery.taxonomySearchService.retrieveOccurences(keys, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void getOccurences(String sessionId) {
        SpeciesDiscovery.taxonomySearchService.getOccurrencesBatch(sessionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected BaseModelData convertToData(Occurrence occurence) {
        BaseModelData data = new BaseModelData();
        data.set("latitude", (Object)occurence.getLatitude());
        data.set("longitude", (Object)occurence.getLongitude());
        data.set("catalogNumber", (Object)occurence.getCatalogNumber());
        data.set("country", (Object)occurence.getCountry());
        data.set("earliestDateCollected", (Object)occurence.getEarliestDateCollected());
        data.set("latestDateCollected", (Object)occurence.getLatestDateCollected());
        return data;
    }
}

