/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.client;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.SpeciesView;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.resources.Resources;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.GridField;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.JavascriptInjector;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.application.speciesmanagement.speciesdiscovery.client.util.Util;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.ResultRow;

public class DescriptiveSpeciesGrid
extends ContentPanel
implements SpeciesView {
    protected static final String TOGGLE_CLASS = "SPECIES_TOGGLE";
    private Grid<ModelData> grid;
    protected CheckBoxSelectionModel<ModelData> selectionModel;

    public DescriptiveSpeciesGrid(ListStore<ModelData> store) {
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        this.selectionModel = new CheckBoxSelectionModel();
        this.selectionModel.setSelectionMode(Style.SelectionMode.MULTI);
        columns.add(this.selectionModel.getColumn());
        ColumnConfig descriptiveName = Util.createColumnConfig((GridField)SpeciesGridFields.COMMON_NAMES, (int)250);
        columns.add(descriptiveName);
        JavascriptInjector.inject((String)Resources.INSTANCE.getToggleJavaScript().getText());
        ColumnConfig descriptiveTaxonomy = Util.createColumnConfig((GridField)SpeciesGridFields.TAXON, (int)350);
        columns.add(descriptiveTaxonomy);
        ColumnConfig datasourceColumn = Util.createColumnConfig((GridField)SpeciesGridFields.PROVENANCE, (int)350);
        columns.add(datasourceColumn);
        ColumnConfig productsColumn = Util.createColumnConfig((GridField)SpeciesGridFields.PRODUCTS, (int)350);
        columns.add(productsColumn);
        ColumnModel descriptiveColumnModel = new ColumnModel(columns);
        this.grid = new Grid(store, descriptiveColumnModel);
        this.grid.setBorders(true);
        this.grid.setStripeRows(true);
        this.grid.setSelectionModel((GridSelectionModel)this.selectionModel);
        this.grid.addPlugin((ComponentPlugin)this.selectionModel);
        this.add((Widget)this.grid, (LayoutData)new AnchorData("100% 100%"));
    }

    protected void onShow() {
        super.onShow();
        this.reload();
    }

    public void reload() {
    }

    public List<ResultRow> getSelectedRows() {
        LinkedList<ResultRow> selectedRows = new LinkedList<ResultRow>();
        for (ModelData selected : this.grid.getSelectionModel().getSelectedItems()) {
            selectedRows.add((ResultRow)selected.get(SpeciesGridFields.ROW.getId()));
        }
        return selectedRows;
    }
}

