/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.server.common;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.common.Fetcher;

public class FetchingSession<T> {
    protected static final int QUEUE_CAPACITY = 30;
    protected static final int THREAD_POOL_CAPACITY = 10;
    protected BlockingQueue<T> queue = new LinkedBlockingQueue(30);
    protected List<Fetcher<T>> fetchers = new LinkedList();
    protected Executor executor = Executors.newFixedThreadPool(10);

    public void addFetcherAndRun(Fetcher<T> fetcher) {
        fetcher.setResultQueue(this.queue);
        this.fetchers.add(fetcher);
        this.executor.execute((Runnable)fetcher);
    }

    public void close() {
        for (Fetcher fetcher : this.fetchers) {
            fetcher.close();
        }
    }

    public boolean isComplete() {
        boolean complete = true;
        for (Fetcher fetcher : this.fetchers) {
            complete &= fetcher.isComplete();
        }
        return complete &= this.queue.isEmpty();
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }
}

