/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanagement.speciesdiscovery.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.GBIFServiceClient;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.data.Category;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.data.DataProvider;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.data.DataSet;
import org.gcube.application.speciesmanagement.speciesdiscovery.server.data.DataSetResult;
import org.gcube.application.speciesmanagement.speciesdiscovery.shared.Occurrence;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;

/*
 * Exception performing whole class analysis ignored.
 */
public class GBIFServiceClient {
    protected static final int PORT = 8181;
    protected static final String SERVER_ADDRESS = "dlib32.isti.cnr.it";
    protected static final String SEARCH_OPERATION = "0";
    protected static final String OCCURENCIES_OPERATION = "1";
    protected static final String SEPARATOR = "|";

    public static Iterator<String> search(String searchTerm) throws Exception {
        Iterator result = GBIFServiceClient.makeSearch((String)searchTerm);
        return result;
    }

    public static DataProvider convertToDataProvider(String data) throws Exception {
        Tree tree = Bindings.fromReader((Reader)new StringReader(data));
        DataProvider dataProvider = GBIFServiceClient.convertToDataProvider((Tree)tree);
        return dataProvider;
    }

    protected static DataProvider convertToDataProvider(Tree root) {
        String name = GBIFServiceClient.getLeafValue((InnerNode)root, (String)"name");
        DataProvider dataProvider = new DataProvider(root.id(), name);
        LinkedList<DataSet> datasets = new LinkedList<DataSet>();
        for (Edge edge : root.edges("dataSet")) {
            InnerNode dataSetNode = (InnerNode)edge.target();
            DataSet dataSet = GBIFServiceClient.convertToDataSet((InnerNode)dataSetNode);
            datasets.add(dataSet);
        }
        dataProvider.setDatasets(datasets);
        return dataProvider;
    }

    protected static DataSet convertToDataSet(InnerNode node) {
        String id = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"id");
        String name = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"name");
        DataSet dataSet = new DataSet(id, name, "");
        LinkedList<DataSetResult> results = new LinkedList<DataSetResult>();
        for (Edge edge : node.edges("taxon")) {
            InnerNode dataSetResultNode = (InnerNode)edge.target();
            DataSetResult result = GBIFServiceClient.convertToDataSetResult((InnerNode)dataSetResultNode);
            results.add(result);
        }
        dataSet.setResults(results);
        return dataSet;
    }

    protected static DataSetResult convertToDataSetResult(InnerNode node) {
        String id = node.id();
        String name = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"name");
        String rank = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"rank");
        int occurencesCount = -1;
        try {
            occurencesCount = Integer.parseInt(node.attribute("occurrencesCount"));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        DataSetResult result = new DataSetResult(id, name, rank, occurencesCount);
        LinkedList<Category> categories = new LinkedList<Category>();
        InnerNode child = node;
        while (child.hasEdge("taxon")) {
            child = (InnerNode)child.edge("taxon").target();
            id = GBIFServiceClient.getLeafValue((InnerNode)child, (String)"uri");
            name = GBIFServiceClient.getLeafValue((InnerNode)child, (String)"name");
            rank = GBIFServiceClient.getLeafValue((InnerNode)child, (String)"rank");
            Category category = new Category(id, name, rank);
            categories.add(category);
        }
        Collections.reverse(categories);
        result.setParentCategories(categories);
        return result;
    }

    protected static String getLeafValue(InnerNode node, String label) {
        if (!node.hasEdge(label)) {
            return null;
        }
        Node target = node.edge(label).target();
        if (target instanceof Leaf) {
            return ((Leaf)target).value();
        }
        return null;
    }

    protected static Iterator<String> makeSearch(String searchTerm) throws UnknownHostException, IOException {
        System.out.println("searchTerm: " + searchTerm);
        StringBuilder request = new StringBuilder("0");
        request.append("|");
        request.append(searchTerm);
        System.out.println("request: " + request.toString());
        Socket socket = new Socket("dlib32.isti.cnr.it", 8181);
        socket.getOutputStream().write(request.toString().getBytes());
        socket.getOutputStream().write(10);
        socket.getOutputStream().flush();
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        1 iterator = new /* Unavailable Anonymous Inner Class!! */;
        return iterator;
    }

    public static List<Occurrence> getOccurences(String providerId, String datasetId, String taxonKey, String scientificName) throws Exception {
        System.out.println("getOccurences providerId: " + providerId + " datasetId: " + datasetId + " taxonKey: " + taxonKey + " scientificName: " + scientificName);
        String result = GBIFServiceClient.requestOccurences((String)providerId, (String)datasetId, (String)taxonKey, (String)scientificName);
        Tree tree = Bindings.fromReader((Reader)new StringReader(result));
        LinkedList<Occurrence> occurences = new LinkedList<Occurrence>();
        for (Edge edge : tree.edges("occurence")) {
            InnerNode occurenceNode = (InnerNode)edge.target();
            Occurrence occurence = GBIFServiceClient.convertToOccurence((InnerNode)occurenceNode);
            occurences.add(occurence);
        }
        return occurences;
    }

    protected static Occurrence convertToOccurence(InnerNode node) {
        String catalogNumber = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"catalogNumber");
        String country = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"country");
        String earliestDateCollected = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"earliestDateCollected");
        String latestDateCollected = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"latestDateCollected");
        String latitude = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"latitude");
        String longitude = GBIFServiceClient.getLeafValue((InnerNode)node, (String)"longitude");
        return new Occurrence(latitude, longitude, catalogNumber, country, earliestDateCollected, latestDateCollected);
    }

    protected static String requestOccurences(String providerId, String datasetId, String taxonKey, String scientificName) throws UnknownHostException, IOException, ClassNotFoundException {
        StringBuilder request = new StringBuilder("1");
        request.append("|");
        request.append(providerId);
        request.append("|");
        request.append(datasetId);
        request.append("|");
        request.append(taxonKey);
        request.append("|");
        request.append(scientificName);
        System.out.println("request: " + request.toString());
        Socket socket = new Socket("dlib32.isti.cnr.it", 8181);
        socket.getOutputStream().write(request.toString().getBytes());
        socket.getOutputStream().write(10);
        socket.getOutputStream().flush();
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        String result = (String)ois.readObject();
        ois.close();
        socket.close();
        return result;
    }

    public static void main(String[] args) throws Exception {
        Iterator iterator = GBIFServiceClient.search((String)"Scaridae");
        System.out.println("Results:");
        while (iterator.hasNext()) {
            System.out.println((String)iterator.next());
        }
    }
}

