/**
 * 
 */
package org.gcube.vremanagement.executor.scheduledtask;

import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.common.core.publisher.is.legacy.application.ApplicationProfileBuilder;
import org.gcube.common.core.publisher.is.legacy.container.ContainerProfileBuilder;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.Constants;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = SEMapper.CLASS_PROPERTY)
public class ScheduledTask extends org.gcube.vremanagement.executor.plugin.ScheduledTask {

	protected String context;
	protected String ownerId;

	protected ScheduledTask() {
	}

	public ScheduledTask(UUID uuid, LaunchParameter launchParameter) throws Exception {
		this(uuid, launchParameter, generateRunOn());
	}

	public ScheduledTask(UUID uuid, LaunchParameter launchParameter, RunOn runOn) throws Exception {
		this.uuid = uuid;
		this.launchParameter = launchParameter;
		Secret secret = SecretManagerProvider.get();
		this.context = secret.getContext();
		this.ownerId = secret.getOwner().getId();
		this.runOn = runOn;
	}

	/**
	 * @return the context
	 */
	public String getContext() {
		return context;
	}

	/**
	 * @return the ownerId
	 */
	public String getOwnerId() {
		return ownerId;
	}

	public static final String LOCALHOST = "localhost";

	public static RunOn generateRunOn() {
		ApplicationContext applicationContext = ContextProvider.get();
		Ref hostingNodeRef = null;
		try {
			ContainerProfileBuilder containerProfileBuilder = new ContainerProfileBuilder(
					applicationContext.container());
			HostingNode hostingNode = containerProfileBuilder.create();
			hostingNodeRef = new Ref(hostingNode.id(), hostingNode.profile().description().name());
		} catch (Exception e) {
			//
			hostingNodeRef = new Ref(LOCALHOST, LOCALHOST);
		}

		Ref eServiceRef = null;
		try {
			ApplicationProfileBuilder applicationProfileBuilder = new ApplicationProfileBuilder(applicationContext);
			GCoreEndpoint gCoreEndpoint = applicationProfileBuilder.create();
			String address = "";
			Group<Endpoint> endpoints = gCoreEndpoint.profile().endpoints();
			for (Endpoint endpoint : endpoints) {
				if (endpoint.name().contains(Constants.remote_management)) {
					continue;
				} else {
					address = endpoint.uri().toString();
					break;
				}
			}

			eServiceRef = new Ref(gCoreEndpoint.id(), address);
		} catch (Exception e) {
			eServiceRef = new Ref(LOCALHOST, LOCALHOST);
		}

		RunOn runOn = new RunOn(hostingNodeRef, eServiceRef);

		return runOn;
	}

	@Override
	public String toString() {
		try {
			return ExtendedSEMapper.getInstance().marshal(this);
		} catch (Exception e) {
			return "ScheduledTask [context=" + context + ", ownerId=" + ownerId + ", uuid="
					+ uuid + ", launchParameter=" + launchParameter + ", runOn=" + runOn + "]";
		}
	}

}
