/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.util.HashMap;
import java.util.Map;
import org.gcube.vremanagement.executor.ContextUtility;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.orientdb.OrientDBPersistenceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SmartExecutorPersistenceFactory {
    private static final Logger logger = LoggerFactory.getLogger(SmartExecutorPersistenceFactory.class);
    private static Map<String, SmartExecutorPersistenceConnector> persistenceConnectors = new HashMap();

    private static synchronized SmartExecutorPersistenceConnector getPersistenceConnector(String context) throws Exception {
        if (context == null) {
            String error = "No Context available.";
            logger.error(error);
            throw new RuntimeException(error);
        }
        logger.trace("Retrieving {} for context {}", (Object)SmartExecutorPersistenceConnector.class.getSimpleName(), (Object)context);
        SmartExecutorPersistenceConnector persistence = (SmartExecutorPersistenceConnector)persistenceConnectors.get(context);
        if (persistence == null) {
            logger.trace("Retrieving {} for context {} not found on internal {}. Intializing it.", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), context, Map.class.getSimpleName()});
            String className = OrientDBPersistenceConnector.class.getSimpleName();
            SmartExecutorPersistenceConfiguration configuration = new SmartExecutorPersistenceConfiguration(className);
            persistence = new OrientDBPersistenceConnector(configuration);
            persistenceConnectors.put(ContextUtility.getCurrentContext(), persistence);
        }
        return persistence;
    }

    public static SmartExecutorPersistenceConnector getPersistenceConnector() throws Exception {
        String context = ContextUtility.getCurrentContext();
        return SmartExecutorPersistenceFactory.getPersistenceConnector((String)context);
    }

    public static void closeCurrentPersistenceConnector() throws Exception {
        String context = ContextUtility.getCurrentContext();
        SmartExecutorPersistenceFactory.closePersistenceConnector((String)context);
    }

    private static synchronized void closePersistenceConnector(String context) throws Exception {
        SmartExecutorPersistenceConnector persistence = SmartExecutorPersistenceFactory.getPersistenceConnector((String)context);
        if (persistence != null) {
            persistence.close();
            persistenceConnectors.remove(context);
            if (persistenceConnectors.isEmpty()) {
                // empty if block
            }
        }
    }

    public static void closeAll() {
        for (String context : persistenceConnectors.keySet()) {
            try {
                SmartExecutorPersistenceFactory.closePersistenceConnector((String)context);
            }
            catch (Exception e) {
                logger.error("Unable to close {} for context {}", (Object)SmartExecutorPersistenceConnector.class.getSimpleName(), (Object)context);
            }
        }
    }

    public static void shutdown() {
        OrientDBPersistenceConnector.shutdown();
    }
}

