/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.ContextUtility;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.ispublisher.ISPublisher;
import org.gcube.vremanagement.executor.ispublisher.RestISPublisher;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorInitializator
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorInitializator.class);
    public static final long JOIN_TIMEOUT = 1000L;

    public void onInit() {
        SmartExecutorPersistenceConnector smartExecutorPersistenceConnector;
        String context = ContextUtility.getCurrentContext();
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Starting on context {}\n-------------------------------------------------------", (Object)context);
        logger.debug("Getting Available Plugins and their own supported capabilities");
        PluginManager pluginManager = PluginManager.getInstance();
        Map availablePlugins = pluginManager.getAvailablePlugins();
        ApplicationContext applicationContext = ContextProvider.get();
        List isPublishers = ISPublisher.getISPublishers((ApplicationContext)applicationContext);
        for (ISPublisher isPublisher : isPublishers) {
            try {
                isPublisher.unpublishPlugins(true);
            }
            catch (Exception e) {
                logger.error("Unable to unpublish plugins from IS using {}. Trying to continue.", (Object)isPublisher.getClass().getName());
            }
            try {
                isPublisher.publishPlugins(availablePlugins);
            }
            catch (Exception e) {
                if (isPublisher instanceof RestISPublisher) {
                    logger.warn("Unable to create RunningPlugin in context {}. {}", (Object)context, (Object)e.getMessage());
                    continue;
                }
                logger.error("Unable to create ServiceEndpoint in context {}. The Service will be aborted", (Object)context, (Object)e);
                throw new RuntimeException(e);
            }
        }
        try {
            smartExecutorPersistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
        }
        catch (Exception e) {
            logger.error("Unable to instantiate {} for scope {}. The Service will be aborted", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), context, e});
            throw new RuntimeException(e);
        }
        try {
            logger.debug("Going to get Orphan Scheduled Tasks in scope {}", (Object)context);
            List gotScheduledTasks = smartExecutorPersistenceConnector.getScheduledTasks(pluginManager.getAvailablePlugins().keySet());
            ArrayList<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
            for (ScheduledTask scheduledTask : gotScheduledTasks) {
                if (!smartExecutorPersistenceConnector.isOrphan(scheduledTask, true)) continue;
                scheduledTasks.add(scheduledTask);
            }
            if (scheduledTasks.size() == 0) {
                logger.debug("No Orphan Scheduled Tasks this instance can take in charge in scope {}", (Object)context);
            }
            for (ScheduledTask scheduledTask : scheduledTasks) {
                String taskAsString = ExtendedSEMapper.getInstance().marshal((Object)scheduledTask);
                try {
                    smartExecutorPersistenceConnector.reserveScheduledTask(scheduledTask);
                }
                catch (Exception e) {
                    logger.debug("({}) Someone else is going to take in charge the scheduled task {}. Skipping.", (Object)context, (Object)taskAsString);
                    continue;
                }
                1 thread = new /* Unavailable Anonymous Inner Class!! */;
                thread.start();
            }
        }
        catch (Exception e) {
            logger.error("Unable to get Orphan Scheduled Tasksfor scope {}.", (Object)context, (Object)e);
            return;
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Started Successfully on context {}\n-------------------------------------------------------", (Object)context);
    }

    public void onShutdown() {
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Stopping on context {}\n-------------------------------------------------------", (Object)ContextUtility.getCurrentContext());
        try {
            SmartExecutorScheduler scheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            scheduler.stopAll();
            SmartExecutorSchedulerFactory.removeCurrentSmartExecutorScheduler();
        }
        catch (SchedulerException e) {
            logger.error("", (Throwable)e);
        }
        ApplicationContext applicationContext = ContextProvider.get();
        List isPublishers = ISPublisher.getISPublishers((ApplicationContext)applicationContext);
        for (ISPublisher isPublisher : isPublishers) {
            try {
                isPublisher.unpublishPlugins(false);
            }
            catch (Exception e) {
                logger.error("unable to unpublish plugins from IS using {}", (Object)isPublisher.getClass().getName());
            }
        }
        try {
            SmartExecutorPersistenceFactory.closeCurrentPersistenceConnector();
        }
        catch (Throwable e) {
            logger.error("Unable to correctly close {} for context {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), ContextUtility.getCurrentContext(), e});
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Stopped Successfully on context {}\n-------------------------------------------------------", (Object)ContextUtility.getCurrentContext());
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

