package org.gcube.vremanagement.executor;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ContextUtility {
	
	private static Logger logger = LoggerFactory.getLogger(ContextUtility.class);
	
	public static String getCurrentContext() {
		String token = SecurityTokenProvider.instance.get();
		AuthorizationEntry authorizationEntry;
		try {
			authorizationEntry = Constants.authorizationService().get(token);
		} catch(Exception e) {
			logger.trace("Context was not retrieved from token. Going to get it from {}",
					ScopeProvider.class.getSimpleName());
			return ScopeProvider.instance.get();
		}
		String context = authorizationEntry.getContext();
		logger.trace("Context retrieved from token is {}. Context in {} is {}", context,
				ScopeProvider.class.getSimpleName(), ScopeProvider.instance.get());
		return context;
	}
	
	public static String getCurrentContext(String token) throws ObjectNotFound, Exception {
		AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
		String context = authorizationEntry.getContext();
		logger.info("Context of token {} is {}", token, context);
		return context;
	}
	
	public static void setContext(String token) throws ObjectNotFound, Exception {
		SecurityTokenProvider.instance.set(token);
		ScopeProvider.instance.set(getCurrentContext(token));
	}
	
	public static ClientInfo getClientInfo() {
		String token = SecurityTokenProvider.instance.get();
		AuthorizationEntry authorizationEntry;
		try {
			authorizationEntry = Constants.authorizationService().get(token);
		} catch(Exception e) {
			return new ClientInfo() {
				
				/**
				 * Generated Serial Version UID
				 */
				private static final long serialVersionUID = 8311873203596762883L;
				
				@Override
				public ClientType getType() {
					return ClientType.USER;
				}
				
				@Override
				public List<String> getRoles() {
					return new ArrayList<>();
				}
				
				@Override
				public String getId() {
					return "UNKNOWN";
				}
			};
		}
		return authorizationEntry.getClientInfo();
	}
}
