/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.vremanagement.executor.annotation.PURGE;
import org.gcube.vremanagement.executor.api.rest.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.ScheduledTask;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="plugins")
public class RestSmartExecutor
implements SmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(RestSmartExecutor.class);
    private static final String UUID_PATH_PARAM = "UUID";
    private static final String PLUGIN_NAME_PATH_PARAM = "NAME";
    protected static final String LOCATION_HEADER = "Location";
    @Context
    protected UriInfo uriInfo;

    protected void setCalledMethod(String calledMethod) {
        logger.trace("Going to set calledMethod as '{}'", (Object)calledMethod);
        CalledMethodProvider.instance.set(calledMethod);
        logger.info("Arrived request at {} with query parameters {}", (Object)this.uriInfo.getAbsolutePath(), (Object)this.uriInfo.getQueryParameters());
    }

    protected Response.ResponseBuilder addLocation(Response.ResponseBuilder responseBuilder, String id) {
        return responseBuilder.header(LOCATION_HEADER, (Object)String.format("%s %s/%s", this.uriInfo.getAbsolutePath().toString(), id));
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAvailablePlugins() throws ExecutorException {
        this.setCalledMethod("GET /plugins");
        try {
            PluginManager pluginManager = PluginManager.getInstance();
            Map availablePlugins = pluginManager.getAvailablePlugins();
            ArrayList plugins = new ArrayList(availablePlugins.values());
            return ExtendedSEMapper.getInstance().marshal(PluginDeclaration.class, plugins);
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{NAME}/executions")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getScheduled(@PathParam(value="NAME") String pluginName) throws ExecutorException {
        this.setCalledMethod("GET /plugins/" + pluginName + "/" + "executions");
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            ArrayList<PluginDeclaration> pluginDeclarations = new ArrayList<PluginDeclaration>();
            if (pluginName.compareTo("ORPHAN") != 0) {
                PluginManager pluginManager = PluginManager.getInstance();
                Map availablePlugins = pluginManager.getAvailablePlugins();
                PluginDeclaration pluginDeclaration = (PluginDeclaration)availablePlugins.get(pluginName);
                if (pluginDeclaration == null) {
                    String error = String.format("This SmartExecutor instace does not manage any plugin with name %s", pluginName);
                    logger.error(error);
                    throw new ExecutorException(error);
                }
                pluginDeclarations.add(pluginDeclaration);
            }
            List scheduledTasks = persistenceConnector.getOrphanScheduledTasks(pluginDeclarations);
            ArrayList<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
            for (org.gcube.vremanagement.executor.scheduledtask.ScheduledTask scheduledTask : scheduledTasks) {
                ScheduledTask task = new ScheduledTask(scheduledTask.getUUID(), scheduledTask.getRunOn(), scheduledTask.getLaunchParameter());
                tasks.add(task);
            }
            return SEMapper.getInstance().marshal(ScheduledTask.class, tasks);
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @POST
    @Path(value="/{NAME}/executions")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"text/plain"})
    public String launch(@PathParam(value="NAME") String pluginName, String launchParameterString) throws ExecutorException {
        this.setCalledMethod("POST /plugins/" + pluginName + "/" + "executions");
        try {
            logger.info("Requested to launch {} ({})", (Object)pluginName, (Object)launchParameterString);
            LaunchParameter launchParameter = (LaunchParameter)ExtendedSEMapper.getInstance().unmarshal(LaunchParameter.class, launchParameterString);
            if (pluginName == null) {
                String error = String.format("Plugin Name provided in the URL (%s) cannot be null", pluginName);
                logger.error(error);
                throw new InputsNullException(error);
            }
            if (pluginName.compareTo(launchParameter.getPluginName()) != 0) {
                String error = String.format("Plugin Name provided in the URL (%s) does not match with the one provided in %s (%s)", pluginName, LaunchParameter.class.getSimpleName(), launchParameter.getPluginName());
                logger.error(error);
                throw new InvalidInputsException(error);
            }
            SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            UUID uuid = smartExecutorScheduler.schedule(launchParameter, null);
            logger.info("{} ({}) has been lauched with uuid {}", new Object[]{pluginName, launchParameterString, uuid});
            return uuid.toString();
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{NAME}/executions/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getLaunchState(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier, @QueryParam(value="iteration") Integer iteration) throws ExecutorException {
        this.setCalledMethod("GET /plugins/" + pluginName + "/" + "executions" + "/{" + UUID_PATH_PARAM + "}");
        PluginStateEvolution pluginStateEvolution = null;
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            pluginStateEvolution = persistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier), iteration);
            logger.info("{} for {} (iteration n. {}) is {}", new Object[]{PluginStateEvolution.class.getSimpleName(), executionIdentifier, iteration, pluginStateEvolution});
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
        if (pluginName.compareTo(pluginStateEvolution.getPluginDeclaration().getName()) != 0) {
            String error = String.format("Plugin Name provided in the URL (%s) does not match with the one got from %s (%s)", pluginName, PluginStateEvolution.class.getSimpleName(), pluginStateEvolution.getPluginDeclaration().getName());
            throw new InvalidInputsException(error);
        }
        try {
            return ExtendedSEMapper.getInstance().marshal((Object)pluginStateEvolution);
        }
        catch (JsonProcessingException e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{NAME}/executions/{UUID}")
    public boolean delete(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier, @QueryParam(value="unschedule") Boolean unschedule) throws ExecutorException {
        try {
            if (unschedule == null) {
                unschedule = false;
            }
            if (unschedule.booleanValue()) {
                this.setCalledMethod(PURGE.class.getSimpleName() + " /" + "plugins" + "/" + pluginName + "/" + "executions" + "/{" + UUID_PATH_PARAM + "}");
            } else {
                this.setCalledMethod("DELETE /plugins/" + pluginName + "/" + "executions" + "/{" + UUID_PATH_PARAM + "}");
            }
            logger.info("Requested to delete for {} with UUID {}{}", new Object[]{pluginName, executionIdentifier, unschedule != false ? "globally" : ""});
            boolean currentStopped = true;
            try {
                SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
                UUID uuid = UUID.fromString(executionIdentifier);
                smartExecutorScheduler.stop(uuid, unschedule.booleanValue());
            }
            catch (SchedulerNotFoundException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulerException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulePersistenceException e) {
                logger.error("Error removing scheduled task from persistence.", (Throwable)e);
            }
            catch (ExecutorException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            logger.info("{} with UUID {} was{} stopped successfully", new Object[]{pluginName, executionIdentifier, currentStopped ? "" : " NOT"});
            return currentStopped;
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @PURGE
    @Path(value="/{NAME}/executions/{UUID}")
    public boolean purge(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier) throws ExecutorException {
        return this.delete(pluginName, executionIdentifier, Boolean.valueOf(true));
    }
}

