/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduledtask;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ScheduledTask {
    public static final String LAUNCH_PARAMETER = "launchParameter";
    protected UUID uuid;
    @JsonProperty(value="launchParameter")
    protected LaunchParameter launchParameter;
    protected String scope;
    protected String token;
    protected ClientInfo clientInfo;
    protected RunOn runOn;
    public static final String LOCALHOST = "localhost";

    protected ScheduledTask() {
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter) {
        this(uuid, launchParameter, ScheduledTask.generateRunOn());
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter, RunOn runOn) {
        this.uuid = uuid;
        this.launchParameter = launchParameter;
        this.token = SecurityTokenProvider.instance.get();
        this.scope = SmartExecutorInitializator.getCurrentScope();
        this.clientInfo = SmartExecutorInitializator.getClientInfo();
        this.runOn = runOn;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getScope() {
        return this.scope;
    }

    public String getToken() {
        return this.token;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public RunOn getRunOn() {
        return this.runOn;
    }

    public static RunOn generateRunOn() {
        Ref hostingNodeRef = null;
        try {
            HostingNode hostingNode = (HostingNode)ContextProvider.get().container().profile(HostingNode.class);
            hostingNodeRef = new Ref(hostingNode.id(), hostingNode.profile().description().name());
        }
        catch (Exception e) {
            hostingNodeRef = new Ref("localhost", "localhost");
        }
        Ref eServiceRef = null;
        try {
            GCoreEndpoint gCoreEndpoint = (GCoreEndpoint)ContextProvider.get().profile(GCoreEndpoint.class);
            String address = "";
            Group endpoints = gCoreEndpoint.profile().endpoints();
            for (GCoreEndpoint.Profile.Endpoint endpoint : endpoints) {
                if (endpoint.name().contains("remote-management")) continue;
                address = endpoint.uri().toString();
                break;
            }
            eServiceRef = new Ref(gCoreEndpoint.id(), address);
        }
        catch (Exception e) {
            eServiceRef = new Ref("localhost", "localhost");
        }
        RunOn runOn = new RunOn(hostingNodeRef, eServiceRef);
        return runOn;
    }

    public LaunchParameter getLaunchParameter() {
        return this.launchParameter;
    }
}

