/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.pluginmanager;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.vremanagement.executor.exception.AlreadyInFinalStateException;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.plugin.PercentageSetter;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.gcube.vremanagement.executor.pluginmanager.PercentageSetterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnablePlugin<T extends Plugin<? extends PluginDeclaration>>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(RunnablePlugin.class);
    public static final String MAX_LAUNCH_TIMES = "___max_launch_times___";
    protected static final String SEPARATOR = "---";
    protected final T plugin;
    protected final Map<String, Object> inputs;
    protected final UUID uuid;
    protected final int iterationNumber;
    protected final List<PluginStateNotification> pluginStateNotifications;
    protected PluginStateEvolution actualStateEvolution;

    public RunnablePlugin(T plugin, Map<String, Object> inputs, UUID uuid, int iterationNumber, List<PluginStateNotification> pluginStateNotifications) {
        this.plugin = plugin;
        this.plugin.setPercentageSetter((PercentageSetter)new PercentageSetterImpl(this));
        this.inputs = inputs;
        this.uuid = uuid;
        this.iterationNumber = iterationNumber;
        this.pluginStateNotifications = pluginStateNotifications;
        try {
            this.setState(PluginState.CREATED);
        }
        catch (AlreadyInFinalStateException | InvalidPluginStateEvolutionException e) {
            logger.error(" --- You should not be here. Seem that the {} is suspended before the istance is created. This is really STRANGE.", (Object)uuid);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        try {
            this.setState(PluginState.RUNNING);
            this.plugin.launch(this.inputs);
            this.setState(PluginState.DONE);
        }
        catch (AlreadyInFinalStateException e1) {
            return;
        }
        catch (Exception e) {
            logger.trace(String.format("Thread %s failed", this.toString()), (Throwable)e);
            try {
                this.setState(PluginState.FAILED, e);
            }
            catch (AlreadyInFinalStateException | InvalidPluginStateEvolutionException e1) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    public T getPlugin() {
        return (T)this.plugin;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    protected synchronized void setPercentage(Integer percentage) throws AlreadyInFinalStateException, InvalidPluginStateEvolutionException {
        PluginState pluginState = this.actualStateEvolution.getPluginState();
        if (pluginState != PluginState.RUNNING) {
            throw new InvalidPluginStateEvolutionException("Percentage can be set only for runnign plugin");
        }
        this.setState(pluginState, percentage, null);
    }

    public synchronized void setState(PluginState pluginState) throws AlreadyInFinalStateException, InvalidPluginStateEvolutionException {
        Integer percentage = 0;
        if (this.actualStateEvolution != null) {
            percentage = this.actualStateEvolution.getPercentage();
        }
        if (pluginState == PluginState.DONE) {
            percentage = 100;
        }
        this.setState(pluginState, percentage, null);
    }

    public synchronized void setState(PluginState pluginState, Exception e) throws AlreadyInFinalStateException, InvalidPluginStateEvolutionException {
        Integer percentage = 0;
        if (this.actualStateEvolution != null) {
            percentage = this.actualStateEvolution.getPercentage();
        }
        Exception exception = null;
        if (pluginState == PluginState.FAILED) {
            exception = new Exception(e);
        }
        this.setState(pluginState, percentage, exception);
    }

    protected void setState(PluginState pluginState, Integer percentage, Exception exception) throws AlreadyInFinalStateException, InvalidPluginStateEvolutionException {
        long timestamp = Calendar.getInstance().getTimeInMillis();
        if (this.actualStateEvolution != null && this.actualStateEvolution.getPluginState().isFinalState()) {
            logger.trace("At {} Trying to set {} in {} state, but it was already in the final state {}", new Object[]{timestamp, this.uuid, pluginState.toString(), this.actualStateEvolution.toString()});
            throw new AlreadyInFinalStateException();
        }
        PluginStateEvolution pluginStateEvolution = new PluginStateEvolution(this.uuid, this.iterationNumber, timestamp, this.plugin.getPluginDeclaration(), pluginState, percentage);
        for (PluginStateNotification pluginStateNotification : this.pluginStateNotifications) {
            String pluginStateNotificationName = pluginStateNotification.getClass().getSimpleName();
            try {
                logger.debug("Notifing Plugin State Evolution {} to {}.", (Object)pluginStateEvolution, (Object)pluginStateNotificationName);
                pluginStateNotification.pluginStateEvolution(pluginStateEvolution, exception);
            }
            catch (Exception e) {
                logger.error("Unable to Notify Plugin State Evolution {} to {}.", (Object)pluginStateEvolution, (Object)pluginStateNotificationName);
            }
        }
        this.actualStateEvolution = pluginStateEvolution;
    }

    public String toString() {
        return String.format("UUID : %s, Iteration : %d,  Plugin : %s", this.uuid.toString(), this.iterationNumber, this.plugin.getPluginDeclaration().getName());
    }

    public void stop() throws Exception {
        try {
            this.setState(PluginState.STOPPED);
            this.plugin.stop();
        }
        catch (AlreadyInFinalStateException alreadyInFinalStateException) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
    }
}

