/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.vremanagement.executor.SmartExecutorImpl;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement(name="plugin-registration-handler")
public class SmartExecutorInitializator
extends ApplicationLifecycleHandler {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorInitializator.class);
    public static final long JOIN_TIMEOUT = 1000L;

    private static void publishScopedResource(Resource resource, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)resource, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            logger.debug("Trying to publish to {}:\n{}", scopes, (Object)stringWriter);
            scopedPublisher.create(resource, scopes);
        }
        catch (RegistryNotFoundException e) {
            logger.error("The resource was not published", (Throwable)e);
            throw e;
        }
    }

    private static void unPublishScopedResource(Resource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        logger.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove(resource);
        logger.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private static short[] getVersionSlice(String version, int wantedLenght) {
        logger.trace("Trying to parse {}", (Object)version);
        short[] versionSlices = new short[wantedLenght];
        for (int j = 0; j < wantedLenght; ++j) {
            versionSlices[j] = (short)(j == 0 ? 1 : 0);
        }
        try {
            String[] stringSlices = version.split("[.-]");
            for (int i = 0; i < stringSlices.length; ++i) {
                logger.trace("Parsing version slice n. {} wich is '{}'", (Object)i, (Object)stringSlices[i]);
                if (i < wantedLenght) {
                    try {
                        short n;
                        versionSlices[i] = n = Short.parseShort(stringSlices[i]);
                        logger.trace("Version slice n. {} wich is '{}' parsed as short {}", new Object[]{i, stringSlices[i], n});
                    }
                    catch (NumberFormatException nfe) {
                        logger.trace("Version slice n. {} wich is '{}' failed to parse. The default value {} will be used", new Object[]{i, stringSlices[i], versionSlices[i]});
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.trace("Error parsing the supplied version the default will be used", (Object)versionSlices);
        }
        logger.trace("Version {} parsed as {}", (Object)version, (Object)versionSlices);
        return versionSlices;
    }

    private static String getRunningOn(ContainerConfiguration containerConfiguration) {
        return String.format("%s:%s", containerConfiguration.hostname(), containerConfiguration.port());
    }

    protected static ServiceEndpoint createServiceEndpoint() {
        logger.debug("Getting Available Plugins and their own supported capabilities");
        PluginManager pluginManager = PluginManager.getInstance();
        logger.debug("Creating ServiceEndpoint to publish on IS available plugins and their own supported capabilities");
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = serviceEndpoint.newProfile();
        profile.category(SmartExecutorImpl.ctx.configuration().serviceClass());
        profile.name(SmartExecutorImpl.ctx.configuration().name());
        String version = SmartExecutorImpl.ctx.configuration().version();
        profile.version(version);
        profile.description(SmartExecutorImpl.ctx.configuration().description());
        String runningOn = SmartExecutorInitializator.getRunningOn((ContainerConfiguration)SmartExecutorImpl.ctx.container().configuration());
        Platform platform = profile.newPlatform();
        platform.name(runningOn);
        short[] versionSlices = SmartExecutorInitializator.getVersionSlice((String)version, (int)4);
        platform.version(versionSlices[0]);
        platform.minorVersion(versionSlices[1]);
        platform.buildVersion(versionSlices[2]);
        platform.revisionVersion(versionSlices[3]);
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.hostedOn(runningOn);
        runtime.status(SmartExecutorImpl.ctx.configuration().mode().toString());
        Group accessPoints = profile.accessPoints();
        Map availablePlugins = pluginManager.getAvailablePlugins();
        for (String pluginName : availablePlugins.keySet()) {
            ServiceEndpoint.AccessPoint accessPointElement = new ServiceEndpoint.AccessPoint();
            accessPointElement.name(pluginName);
            PluginDeclaration pluginDeclaration = (PluginDeclaration)availablePlugins.get(pluginName);
            accessPointElement.description(pluginDeclaration.getDescription());
            Group properties = accessPointElement.properties();
            ServiceEndpoint.Property propertyVersionElement = new ServiceEndpoint.Property();
            propertyVersionElement.nameAndValue("Version", pluginDeclaration.getVersion());
            properties.add((Object)propertyVersionElement);
            Map pluginCapabilities = pluginDeclaration.getSupportedCapabilities();
            for (String capabilityName : pluginCapabilities.keySet()) {
                ServiceEndpoint.Property propertyElement = new ServiceEndpoint.Property();
                propertyElement.nameAndValue(capabilityName, (String)pluginCapabilities.get(capabilityName));
                properties.add((Object)propertyElement);
            }
            accessPoints.add((Object)accessPointElement);
        }
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)serviceEndpoint, (Writer)stringWriter);
        logger.debug("The created ServiceEndpoint profile is\n{}", (Object)stringWriter.toString());
        return serviceEndpoint;
    }

    public static List<String> getScopes(ApplicationContext applicationContext) {
        HashSet scopes;
        ScopeGroup scopeGroup = ((GCoreEndpoint)applicationContext.profile(GCoreEndpoint.class)).scopes();
        if (scopeGroup == null || scopeGroup.isEmpty()) {
            Set applicationScopes = applicationContext.configuration().startScopes();
            Set containerScopes = applicationContext.container().configuration().startScopes();
            if (applicationScopes == null || applicationScopes.isEmpty()) {
                scopes = containerScopes;
                logger.debug("Application Scopes ({}). The Container Scopes ({}) will be used.", (Object)applicationScopes, (Object)scopes);
            } else {
                logger.debug("Container Scopes ({}). Application Scopes ({}) will be used.", (Object)containerScopes, (Object)applicationScopes);
                scopes = new HashSet(applicationScopes);
            }
        } else {
            scopes = scopeGroup.asCollection();
        }
        return new ArrayList<String>(scopes);
    }

    private void cleanServiceEndpoints(String scope) {
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format("$resource/Profile/Category/text() eq '%s'", SmartExecutorImpl.ctx.configuration().serviceClass())).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", SmartExecutorImpl.ctx.configuration().name())).addCondition(String.format("$resource/Profile/RunTime/HostedOn/text() eq '%s'", SmartExecutorInitializator.getRunningOn((ContainerConfiguration)SmartExecutorImpl.ctx.container().configuration()))).setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List serviceEndpoints = client.submit((Query)query);
            for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
                try {
                    logger.debug("Trying to unpublish the old ServiceEndpoint with ID {} from scope {}", (Object)serviceEndpoint.id(), (Object)scope);
                    SmartExecutorInitializator.unPublishScopedResource((Resource)serviceEndpoint);
                }
                catch (Exception e) {
                    logger.debug("Exception tryng to unpublish the old ServiceEndpoint with ID {} from scope {}", new Object[]{serviceEndpoint.id(), scope, e});
                }
            }
        }
        catch (Exception e) {
            logger.debug("An Exception occur while checking and/or unpublishing old ServiceEndpoint", (Throwable)e);
        }
    }

    public void onStart(ApplicationLifecycleEvent.Start applicationLifecycleEventStart) {
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Starting\n-------------------------------------------------------");
        SmartExecutorImpl.ctx = (ApplicationContext)applicationLifecycleEventStart.context();
        ServiceEndpoint serviceEndpoint = SmartExecutorInitializator.createServiceEndpoint();
        List scopes = SmartExecutorInitializator.getScopes((ApplicationContext)SmartExecutorImpl.ctx);
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            this.cleanServiceEndpoints(scope);
            try {
                SmartExecutorPersistenceFactory.getPersistenceConnector();
            }
            catch (Exception e) {
                logger.error("Unable to isntantiate {} for scope {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), scope, e});
                throw new RuntimeException(e);
            }
        }
        try {
            SmartExecutorInitializator.publishScopedResource((Resource)serviceEndpoint, (List)scopes);
        }
        catch (RegistryNotFoundException e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error("Unable to Create ServiceEndpoint. the Service will be aborted", (Throwable)e);
            return;
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Started Successfully\n-------------------------------------------------------");
    }

    public void onStop(ApplicationLifecycleEvent.Stop applicationLifecycleEventStop) {
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Stopping\n-------------------------------------------------------");
        SmartExecutorScheduler.getInstance().stopAll();
        List scopes = SmartExecutorInitializator.getScopes((ApplicationContext)SmartExecutorImpl.ctx);
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            this.cleanServiceEndpoints(scope);
            try {
                SmartExecutorPersistenceFactory.getPersistenceConnector().close();
            }
            catch (Exception e) {
                logger.error("Unable to correctly close {} for scope {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), scope, e});
            }
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Stopped Successfully\n-------------------------------------------------------");
    }
}

