/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.pluginmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private static PluginManager pluginManager;
    private Map<String, PluginDeclaration> availablePlugins;

    public static PluginManager getInstance() {
        if (pluginManager == null) {
            pluginManager = new PluginManager();
        }
        return pluginManager;
    }

    protected PluginManager() {
        logger.debug("Loading plugins available on classpath");
        this.availablePlugins = new HashMap();
        ServiceLoader<PluginDeclaration> serviceLoader = ServiceLoader.load(PluginDeclaration.class);
        for (PluginDeclaration pluginDeclaration : serviceLoader) {
            try {
                logger.debug(String.format("%s plugin found", pluginDeclaration.getName()));
                pluginDeclaration.init();
                String name = pluginDeclaration.getName();
                this.availablePlugins.put(name, pluginDeclaration);
            }
            catch (Exception e) {
                logger.debug(String.format("%s not initialized correctly. It will not be used", pluginDeclaration.getName()));
            }
        }
    }

    public PluginDeclaration getPlugin(String name) {
        return (PluginDeclaration)this.availablePlugins.get(name);
    }

    public Map<String, PluginDeclaration> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

