/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.UUID;
import org.gcube.vremanagement.executor.persistence.JDBCPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.Persistence;
import org.gcube.vremanagement.executor.persistence.PersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPersistence
extends Persistence<JDBCPersistenceConnector> {
    private static Logger logger = LoggerFactory.getLogger(JDBCPersistence.class);
    private final Connection connection;

    public JDBCPersistence(JDBCPersistenceConnector jdbcPersistenceConnector, String name, UUID uuid) {
        super((PersistenceConnector)jdbcPersistenceConnector, name, uuid);
        this.connection = jdbcPersistenceConnector.getConnection();
    }

    public void addEvolution(long timestamp, PluginState pluginState) throws Exception {
        this.connection.setAutoCommit(false);
        String insertPluginEvolution = String.format("INSERT INTO `%s` (`%s`,`%s`,`%s`,`%s`) VALUES (?,?,?,?)", "PluginInstanceEvolution", "uuid", "pluginName", "timestamp", "state");
        logger.info(String.format("Base Query : %s. Parameters : %s,%s%s,%s", insertPluginEvolution, this.uuid.toString(), this.name, timestamp, pluginState.name()));
        PreparedStatement psInsertPluginEvolution = this.connection.prepareStatement(insertPluginEvolution);
        psInsertPluginEvolution.setString(1, this.uuid.toString());
        psInsertPluginEvolution.setString(2, this.name);
        psInsertPluginEvolution.setLong(3, timestamp);
        psInsertPluginEvolution.setInt(4, pluginState.ordinal());
        psInsertPluginEvolution.executeUpdate();
        this.connection.commit();
    }
}

