/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.UUID;
import org.gcube.vremanagement.executor.api.rest.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.util.HTTPCall;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorClientImpl
implements SmartExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SmartExecutorClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String pluginName;
    protected final String address;
    protected HTTPCall httpCall;

    public SmartExecutorClientImpl(String pluginName, String address) {
        this.pluginName = pluginName;
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, SmartExecutorClientImpl.class.getSimpleName());
        }
        return this.httpCall;
    }

    public String launch(String launchParameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        try {
            logger.info("Going to launch {} ", (Object)launchParameter);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("plugins");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(this.pluginName);
            HTTPCall httpCall = this.getHTTPCall();
            String uuid = httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, launchParameter);
            logger.debug("{} launched with UUID {} ", (Object)this.pluginName, (Object)uuid);
            return uuid;
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public UUID launch(LaunchParameter launchParameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        try {
            String uuid = this.launch(SEMapper.marshal((Object)launchParameter));
            return UUID.fromString(uuid);
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPluginStateEvolution(String executionIdentifier, Integer iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        try {
            logger.info("Going to get {} of {} with UUID {} ", new Object[]{PluginStateEvolution.class.getSimpleName(), this.pluginName, executionIdentifier});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("plugins");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(this.pluginName);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(executionIdentifier);
            HTTPCall httpCall = this.getHTTPCall();
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            if (iterationNumber != null) {
                parameters.put("iterationNumber", iterationNumber);
            }
            String pluginStateEvolution = httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            return pluginStateEvolution;
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PluginStateEvolution getPluginStateEvolution(UUID executionIdentifier, Integer iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        try {
            String pluginStateEvolution = this.getPluginStateEvolution(executionIdentifier.toString(), iterationNumber);
            return (PluginStateEvolution)SEMapper.unmarshal(PluginStateEvolution.class, (String)pluginStateEvolution);
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(String executionIdentifier, boolean globally) throws ExecutorException {
        try {
            logger.info("Going to stop plugin with UUID {} ", (Object)executionIdentifier);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("plugins");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(this.pluginName);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(executionIdentifier);
            HTTPCall httpCall = this.getHTTPCall();
            HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
            parameters.put("globally", globally);
            Boolean stopped = httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE, parameters);
            logger.debug("Plugin with UUID {} {} stopped", (Object)executionIdentifier, (Object)(stopped != false ? "successfully" : "was not"));
            return stopped;
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(UUID executionIdentifier, boolean globally) throws ExecutorException {
        return this.delete(executionIdentifier.toString(), globally);
    }
}

