/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.vremanagement.executor.api.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.proxies.SmartExecutorProxy;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmartExecutorProxy
implements SmartExecutorProxy {
    private static Logger logger = LoggerFactory.getLogger(DefaultSmartExecutorProxy.class);
    private ProxyDelegate<SmartExecutor> proxyDelegate;

    public DefaultSmartExecutorProxy(ProxyDelegate<SmartExecutor> proxyDelegate) {
        this.proxyDelegate = proxyDelegate;
    }

    public String launch(final LaunchParameter launchParameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        Call<SmartExecutor, String> call = new Call<SmartExecutor, String>(){

            public String call(SmartExecutor endpoint) throws Exception {
                logger.debug("Calling launch() function");
                return endpoint.launch(launchParameter);
            }
        };
        try {
            return (String)this.proxyDelegate.make((Call)call);
        }
        catch (Exception e) {
            logger.debug("Failed to call launch() function");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public boolean unSchedule(final String executionIdentifier) throws ExecutorException {
        Call<SmartExecutor, Boolean> call = new Call<SmartExecutor, Boolean>(){

            public Boolean call(SmartExecutor endpoint) throws Exception {
                logger.debug("Calling launch() function");
                return endpoint.unSchedule(executionIdentifier);
            }
        };
        try {
            return (Boolean)this.proxyDelegate.make((Call)call);
        }
        catch (Exception e) {
            logger.debug("Failed to call launch() function");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public PluginState getState(final String executionIdentifier) throws PluginInstanceNotFoundException, ExecutorException {
        Call<SmartExecutor, PluginState> call = new Call<SmartExecutor, PluginState>(){

            public PluginState call(SmartExecutor endpoint) throws Exception {
                logger.debug("Calling getState() function");
                return endpoint.getState(executionIdentifier);
            }
        };
        try {
            return (PluginState)this.proxyDelegate.make((Call)call);
        }
        catch (Exception e) {
            logger.debug("Failed to call getState() function");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public PluginState getIterationState(final String executionIdentifier, final int iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        Call<SmartExecutor, PluginState> call = new Call<SmartExecutor, PluginState>(){

            public PluginState call(SmartExecutor endpoint) throws Exception {
                logger.debug("Calling getState() function");
                return endpoint.getIterationState(executionIdentifier, iterationNumber);
            }
        };
        try {
            return (PluginState)this.proxyDelegate.make((Call)call);
        }
        catch (Exception e) {
            logger.debug("Failed to call getState() function");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

