/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gcube.vremanagement.executor.plugin.PercentageSetter;
import org.gcube.vremanagement.executor.plugin.PluginDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin
implements PluginDefinition {
    private static Logger logger = LoggerFactory.getLogger(Plugin.class);
    public static final String PLUGIN_PROPERTIES_SUFFIX_FILENAME = ".properties";
    public static final String GROUP_PROPERTY = "groupId";
    public static final String NAME_PROPERTY = "artifactId";
    public static final String VERSION_PROPERTY = "version";
    public static final String DESCRIPTION_PROPERTY = "description";
    protected Properties properties;
    protected UUID uuid;
    protected int iterationNumber;
    protected PercentageSetter percentageSetter;

    public Plugin() {
        logger.debug("Initializing %s".formatted(this.getClass().getSimpleName()));
        this.percentageSetter = new PercentageSetter(){
            private int percentage = 0;

            @Override
            public void setPercentageEvolution(Integer integer) {
                this.percentage = integer;
            }
        };
        this.properties = new Properties();
        try {
            String filename = this.getClass().getSimpleName() + PLUGIN_PROPERTIES_SUFFIX_FILENAME;
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("META-INF" + File.separator + filename);
            this.properties.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("%s initialized".formatted(this.getClass().getSimpleName()));
    }

    @Override
    public String getGroup() {
        return this.properties.getProperty(GROUP_PROPERTY);
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME_PROPERTY);
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty(VERSION_PROPERTY);
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION_PROPERTY);
    }

    @Override
    public Map<String, String> getSupportedCapabilities() {
        return null;
    }

    public void setPercentageSetter(PercentageSetter percentageSetter) {
        this.percentageSetter = percentageSetter;
    }

    protected void setPercentageEvolution(Integer integer) {
        this.percentageSetter.setPercentageEvolution(integer);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public void setIterationNumber(int iterationNumber) {
        this.iterationNumber = iterationNumber;
    }

    public abstract void launch(Map<String, Object> var1) throws Exception;

    protected abstract void onStop() throws Exception;

    public void stop() throws Exception {
        this.onStop();
    }
}

