/**
 * 
 */
package org.gcube.vremanagement.executor.exception;

import java.io.Serial;


import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.vremanagement.executor.json.SEMapper;

/**
 * @author Luca Frosini (ISTI - CNR)
 *
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = SEMapper.CLASS_PROPERTY)
public class ExecutorException extends Exception {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 150353533672078736L;

	private static final String DEFAULT_MESSAGE = "Executor Exception";
	
	/**
	 * Default constructor with default message.
	 */
	public ExecutorException() {
		super(DEFAULT_MESSAGE);
	}
	
	/**
	 * Constructor with cause.
	 * @param cause the underlying cause of this exception
	 */
	public ExecutorException(Throwable cause) {
		this(DEFAULT_MESSAGE, cause);
	}
	
	/**
	 * Constructor with message.
	 * @param message the detail message
	 */
	public ExecutorException(String message) {
		super(message);
	}
	
	/**
	 * Constructor with message and cause.
	 * @param message the detail message
	 * @param cause the underlying cause of this exception
	 */
	public ExecutorException(String message, Throwable cause){
		super(message, cause);
	}
	
}
