/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.api.types.adapter.MapAdapter;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.gcube.vremanagement.executor.utils.MapCompare;
import org.gcube.vremanagement.executor.utils.ObjectCompare;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class LaunchParameter
implements Comparable<LaunchParameter> {
    public static final String PLUGIN_NAME = "pluginName";
    public static final String PLUGIN_VERSION = "pluginVersion";
    @XmlElement
    @JsonProperty(value="pluginName")
    protected String pluginName;
    @XmlElement
    @JsonProperty(value="pluginVersion")
    protected String pluginVersion;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, String> pluginCapabilities;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, Object> inputs;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, Map<String, String>> pluginStateNotifications;
    @XmlElement
    protected Scheduling scheduling;

    protected LaunchParameter() {
    }

    public LaunchParameter(LaunchParameter launchParameter) {
        this.pluginName = launchParameter.pluginName;
        this.pluginVersion = launchParameter.pluginVersion;
        this.pluginCapabilities = launchParameter.pluginCapabilities;
        this.inputs = launchParameter.inputs;
        this.scheduling = launchParameter.scheduling;
        this.pluginStateNotifications = launchParameter.pluginStateNotifications;
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs) {
        this(pluginName, null, null, inputs, null);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs) {
        this(pluginName, null, pluginCapabilities, inputs, null);
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, null, null, inputs, scheduling);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, null, pluginCapabilities, inputs, scheduling);
    }

    public LaunchParameter(String pluginName, String pluginVersion, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) {
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.pluginCapabilities = pluginCapabilities;
        this.inputs = inputs;
        this.scheduling = scheduling;
        this.pluginStateNotifications = new HashMap<String, Map<String, String>>();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, String> getPluginCapabilities() {
        return this.pluginCapabilities;
    }

    public void setPluginCapabilities(Map<String, String> pluginCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public void addPluginStateNotifications(Class<? extends PluginStateNotification> pluginStateNotification, Map<String, String> inputs) {
        this.pluginStateNotifications.put(pluginStateNotification.getName(), inputs);
    }

    public Map<String, Map<String, String>> getPluginStateNotifications() {
        return this.pluginStateNotifications;
    }

    public void setPluginStateNotifications(Map<String, Map<String, String>> pluginStateNotifications) {
        this.pluginStateNotifications = pluginStateNotifications;
    }

    public String toString() {
        return String.format("{pluginName:%s,pluginVersion:%s,pluginCapabilities:%s,scheduling:%s,inputs:%s,pluginStateNotifications:%s}", this.pluginName, this.pluginVersion, this.pluginCapabilities, this.scheduling, this.inputs, this.pluginStateNotifications);
    }

    @Override
    public int compareTo(LaunchParameter launchParameter) {
        int compareResult = 0;
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<String>().compare(this.pluginName, launchParameter.pluginName);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Scheduling>().compare(this.scheduling, launchParameter.scheduling);
        if (compareResult != 0) {
            return compareResult;
        }
        return new MapCompare().compareMaps(this.inputs, launchParameter.inputs);
    }
}

