/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.vremanagement.executor.utils.ObjectCompare;
import org.quartz.CronExpression;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Scheduling
implements Comparable<Scheduling> {
    @XmlElement
    protected String cronExpression;
    @XmlElement
    protected Integer delay;
    @XmlElement
    protected int schedulingTimes;
    @XmlElement
    protected Long firstStartTime;
    @XmlElement
    protected Long endTime;
    @XmlElement
    protected boolean previuosExecutionsMustBeCompleted;
    @XmlElement
    protected Boolean global;

    protected void init(CronExpression cronExpression, Integer delay, int schedulingTimes, Long firstStartTime, Long endTime, boolean previuosExecutionsMustBeCompleted, Boolean global) {
        this.cronExpression = cronExpression != null ? cronExpression.getCronExpression() : null;
        this.delay = delay;
        this.schedulingTimes = schedulingTimes;
        this.firstStartTime = firstStartTime;
        this.endTime = endTime;
        this.previuosExecutionsMustBeCompleted = previuosExecutionsMustBeCompleted;
        this.global = global;
    }

    protected Scheduling() {
    }

    public Scheduling(CronExpression cronExpression) {
        this.init(cronExpression, null, 0, null, null, false, null);
    }

    public Scheduling(CronExpression cronExpression, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, 0, null, null, previuosExecutionsMustBeCompleted, null);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes) {
        this.init(cronExpression, null, schedulingTimes, null, null, false, null);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, null, null, previuosExecutionsMustBeCompleted, null);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false, null);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted, null);
    }

    public Scheduling(int delay) {
        this.init(null, delay, 0, null, null, false, null);
    }

    public Scheduling(int delay, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, 0, null, null, previuosExecutionsMustBeCompleted, null);
    }

    public Scheduling(int delay, int schedulingTimes) {
        this.init(null, delay, schedulingTimes, null, null, false, null);
    }

    public Scheduling(int delay, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, null, null, previuosExecutionsMustBeCompleted, null);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false, null);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted, null);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public int getSchedulingTimes() {
        return this.schedulingTimes;
    }

    public boolean mustPreviousExecutionsCompleted() {
        return this.previuosExecutionsMustBeCompleted;
    }

    public Long getFirtStartTime() {
        return this.firstStartTime;
    }

    public Long getFirstStartTime() {
        return this.firstStartTime;
    }

    public void setFirstStartTime(Long firstStartTime) {
        this.firstStartTime = firstStartTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Boolean getGlobal() {
        if (this.global == null) {
            return false;
        }
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public String toString() {
        return String.format("CronExpression %s, Delay %d, SchedulingTimes %d, FirstStartTime %d, EndTime %d, PreviuosExecutionsMustBeCompleted %b, Global %b", this.cronExpression, this.delay, this.schedulingTimes, this.firstStartTime, this.endTime, this.previuosExecutionsMustBeCompleted, this.global);
    }

    @Override
    public int compareTo(Scheduling scheduling) {
        int compareResult = 0;
        compareResult = new ObjectCompare<String>().compare(this.cronExpression, scheduling.cronExpression);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Integer>().compare(this.delay, scheduling.delay);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Integer>().compare(new Integer(this.schedulingTimes), new Integer(scheduling.schedulingTimes));
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Long>().compare(this.firstStartTime, scheduling.firstStartTime);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Long>().compare(this.endTime, scheduling.endTime);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Boolean>().compare(new Boolean(this.previuosExecutionsMustBeCompleted), new Boolean(scheduling.previuosExecutionsMustBeCompleted));
        return new ObjectCompare<Boolean>().compare(new Boolean(this.global), new Boolean(scheduling.global));
    }
}

