package org.gcube.vremanagement.executor.plugin;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public enum PluginState {
	/**
	 * The Job is created
	 */
	CREATED(false), 
	/**
	 * The job is running
	 */
	RUNNING(false), 
	/**
	 * The job has been stopped
	 */
	STOPPED(true), 
	/**
	 * The job terminated successfully
	 */
	DONE(true), 
	/**
	 * The failed the execution
	 */
	FAILED(true),
	/**
	 * the job has been discarded by the scheduler. this happen when the launch
	 * parameter require the previous completed for repetitive or recurrent jobs
	 */
	DISCARDED(true);
	
	boolean finalState;
	
	PluginState(boolean finalState){
		this.finalState = finalState;
	}
	
	/**
	 * Return true when the state a is a final state and the job cannot move
	 * in any other state
	 * @return if is a Final State
	 */
	public boolean isFinalState() {
		return finalState;
	}
	
}
