package org.gcube.vremanagement.contextmanager.model.report;

import org.gcube.vremanagement.contextmanager.model.operators.OperationParameters;

public class ReportEntry implements ReportOperation{

	private String operationId;
	private String name;
	private String description;
	private OperationParameters parameters;
	private OperationResult result;
	
	protected ReportEntry() {}

	public ReportEntry(String operationId, String name, String description, OperationResult result) {
		super();
		this.operationId = operationId;
		this.name = name;
		this.description = description;
		this.result = result;
	}

	public ReportEntry(String operationId, String name, String description, OperationResult result, OperationParameters parameters) {
		this(operationId, name, description, result);
		this.parameters = parameters;
	}
	
	public String getOperationId() {
		return operationId;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public OperationParameters getParameters() {
		return parameters;
	}

	public OperationResult getResult() {
		return result;
	}
	
}
