/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.vremanagement.contextmanager.ScopedResource;
import org.gcube.vremanagement.contextmanager.handlers.ResourceHandler;
import org.gcube.vremanagement.contextmanager.model.collectors.BackendConnector;

@Singleton
public class ResourceManager {
    @Inject
    @Any
    Instance<ResourceHandler> resourcesHandlers;
    @Inject
    @Default
    BackendConnector defaultCollector;

    public ScopedResource addResourceToContext(String context, Resource resource) {
        ResourceHandler handler = this.retrieveHandler(resource.type());
        handler.addResource(context, resource);
        return this.getScopedResource(resource);
    }

    public ScopedResource removeResourceFromContext(String context, String id) {
        Resource res = this.retrieveResource(id);
        ResourceHandler handler = this.retrieveHandler(res.type());
        handler.removeResource(context, res);
        return this.getScopedResource(res);
    }

    private Resource retrieveResource(String id) {
        return this.defaultCollector.find(id);
    }

    private ResourceHandler retrieveHandler(Resource.Type type) {
        for (ResourceHandler rh : this.resourcesHandlers) {
            if (!rh.getManagedResources().contains(type)) continue;
            return rh;
        }
        return null;
    }

    private ScopedResource getScopedResource(Resource res) {
        return new ScopedResource(res.id(), res.type().name(), Long.toString(System.currentTimeMillis()));
    }
}

