package org.gcube.vremanagement.contextmanager.services;

import java.util.Arrays;
import java.util.List;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.contextmanager.ResourceManager;
import org.gcube.vremanagement.contextmanager.ContextAppManager;
import org.gcube.vremanagement.contextmanager.handlers.ContextHandler;
import org.gcube.vremanagement.contextmanager.model.types.ContextList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("contexts")
@ManagedBy(ContextAppManager.class)
public class ContextService {

	private static Logger log = LoggerFactory.getLogger(ContextService.class);
	
	ApplicationContext appContext = ContextProvider.get();

	@Inject
	ContextHandler contextHandler;

	@Inject
	ResourceManager resourceHandler;

	@RequestScoped
	@PathParam("vre") 
	String vre;

	@RequestScoped
	@PathParam("resourceId") 
	String resourceId;

	@RequestScoped
	@PathParam("infra") 
	String infra;
	
	@RequestScoped
	@PathParam("vo") 
	String vo;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("")
	public ContextList getContexts() {
		return new ContextList(Arrays.asList("/gcube","/gcube/devsec"));
	}
	
	@PUT
	@Path("/{infra}/{vo}/{vre}")
	public String createVREContext(List<String> resourceIds) {
		try {
			String fullContext = String.format("/%s/%s/%s", infra,vo,vre);
			validateCall(fullContext);
			contextHandler.createContext(fullContext, resourceIds, (ContextAppManager)ApplicationManagerProvider.get());
		}catch (Exception e) {
			// TODO: handle exception
		}
		return null;
	}

	@DELETE
	@Path("/{infra}/{vo}/{vre}")
	public String disposeVREContext() {
		try {
			String fullContext = String.format("/%s/%s/%s", infra,vo,vre);
			validateCall(fullContext);
			contextHandler.removeContext(fullContext, (ContextAppManager)ApplicationManagerProvider.get());
		}catch (Exception e) {
			// TODO: handle exception
		}
		return null;
	}

	@DELETE
	@Path("/{context:(.*(?=/resources))}/resources/{resourceId}")
	public String removeResourceFromContext(@PathParam("context") String context) {
		log.info("remove resource {} from context {}", resourceId, context);
		try {
			validateCall(context);
			resourceHandler.removeResourceFromContext(context, resourceId);
		}catch (Exception e) {
			// TODO: handle exception
		}
		return null;
	}

	@PUT
	@Path("/{context:(.*(?=/resources))}/resources")
	public String addResourceToContext(@PathParam("context") String context, Resource resource) {
		log.info("adding resource {} to context {}", resource.id(), context);
		try {
			validateCall(context);
			resourceHandler.addResourceToContext(context, resource);
		}catch (Exception e) {
			// TODO: handle exception
		}
		return null;
	}

	private void validateCall(String fullContext) throws Exception {
		String currentContext = ScopeProvider.instance.get();
		if (!fullContext.startsWith(currentContext))
			throw new Exception("invalid call");
	}
	
	

}
