/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementUtils {
    private static final Logger _log = LoggerFactory.getLogger(ManagementUtils.class);
    private static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";

    public static Company getCompany() throws PortalException, SystemException {
        return CompanyLocalServiceUtil.getCompanyByWebId((String)ManagementUtils.getDefaultCompanyWebId());
    }

    public static String getDefaultCompanyWebId() {
        String defaultWebId = "";
        try {
            defaultWebId = GetterUtil.getString((String)PropsUtil.get((String)"company.default.web.id"));
        }
        catch (NullPointerException e) {
            _log.info("Cound not find property company.default.web.id in portal.ext file returning default web id: liferay.com");
            return DEFAULT_COMPANY_WEB_ID;
        }
        return defaultWebId;
    }

    public static long getSiteGroupIdFromServletRequest(String serverName) throws SystemException, PortalException {
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            return site.getGroupId();
        }
        _log.warn("serverName is " + serverName + " but i could not find any virtualHost associated to it");
        return -1L;
    }
}

