/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.portal.mailing;

import com.sun.mail.smtp.SMTPSendFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.templates.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotification {
    private static Logger _log = LoggerFactory.getLogger(EmailNotification.class);
    private static final String MAIL_SERVICE_HOST = "localhost";
    private static final String MAIL_SERVICE_PORT = "25";
    private String[] emailrecipients;
    private final List<InternetAddress> emailRecipientsInCC;
    private final List<InternetAddress> emailRecipientsInBCC;
    private final String emailSubject;
    private StringBuffer emailBodyTextHTML;
    private StringBuffer emailBodyTextPlain;
    private Template selectedTemplate;
    private HttpServletRequest request;

    public EmailNotification(String recipient, String subject, String bodyTextHTML, HttpServletRequest httpServletRequest) {
        this(new EmailBuilder(subject, httpServletRequest, recipient).contentTextHTML(bodyTextHTML));
    }

    public EmailNotification(String[] recipients, String subject, String bodyTextHTML, HttpServletRequest httpServletRequest) {
        this(new EmailBuilder(subject, httpServletRequest, recipients).contentTextHTML(bodyTextHTML));
    }

    public EmailNotification(List<String> recipients, String subject, String bodyTextHTML, HttpServletRequest httpServletRequest) {
        this(new EmailBuilder(subject, httpServletRequest, recipients.toArray(new String[recipients.size()])).contentTextHTML(bodyTextHTML));
    }

    private EmailNotification(EmailBuilder builder) {
        this.emailSubject = builder.subject;
        this.request = builder.httpServletRequest;
        this.emailrecipients = builder.emailrecipients;
        this.selectedTemplate = builder.template;
        if (this.selectedTemplate != null) {
            this.emailBodyTextHTML = new StringBuffer(this.selectedTemplate.getTextHTML()).append(EmailNotification.getWarningLegalText(false));
            this.emailBodyTextPlain = new StringBuffer(this.selectedTemplate.getTextPLAIN()).append(EmailNotification.getWarningLegalText(true));
        } else {
            this.emailBodyTextHTML = builder.bodyTextHTML != null ? new StringBuffer(builder.bodyTextHTML).append(EmailNotification.getWarningLegalText(false)) : null;
            this.emailBodyTextPlain = builder.bodyTextPlain != null ? new StringBuffer(builder.bodyTextPlain).append(EmailNotification.getWarningLegalText(true)) : null;
        }
        this.emailRecipientsInCC = builder.emailRecipientsInCC;
        this.emailRecipientsInBCC = builder.emailRecipientsInBCC;
    }

    public void addRecipientInCC(String email) {
        try {
            this.emailRecipientsInCC.add(new InternetAddress(email));
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
    }

    public void addRecipientInBCC(String email) {
        try {
            this.emailRecipientsInBCC.add(new InternetAddress(email));
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
    }

    public void addContentTextPlain(String bodyTextPlain) {
        this.emailBodyTextPlain = new StringBuffer(bodyTextPlain).append(EmailNotification.getWarningLegalText(true));
    }

    public void sendEmail() {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", MAIL_SERVICE_HOST);
        props.put("mail.smtp.port", MAIL_SERVICE_PORT);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(true);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            String emailSender = "";
            String siteName = "";
            if (this.request != null) {
                emailSender = PortalContext.getConfiguration().getSenderEmail(this.request);
                siteName = PortalContext.getConfiguration().getGatewayName(this.request);
            } else {
                emailSender = PortalContext.getConfiguration().getSenderEmail();
                siteName = PortalContext.getConfiguration().getGatewayName();
            }
            InternetAddress from = new InternetAddress(emailSender, siteName);
            mimeMessage.setHeader("Content-Type", "text/html; charset=UTF-8");
            mimeMessage.setFrom((Address)from);
            for (int i = 0; i < this.emailrecipients.length; ++i) {
                InternetAddress address = new InternetAddress(this.emailrecipients[i]);
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)address);
            }
            for (InternetAddress email : this.emailRecipientsInCC) {
                mimeMessage.addRecipient(Message.RecipientType.CC, (Address)email);
            }
            for (InternetAddress email : this.emailRecipientsInBCC) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)email);
            }
            mimeMessage.setSubject(this.emailSubject);
            if (this.emailBodyTextPlain != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setContent((Object)this.emailBodyTextPlain.toString(), "text/plain; charset=UTF-8");
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)this.emailBodyTextHTML.toString(), "text/html; charset=UTF-8");
                MimeMultipart mp = new MimeMultipart("alternative");
                mp.addBodyPart((BodyPart)textPart);
                mp.addBodyPart((BodyPart)htmlPart);
                mimeMessage.setContent((Multipart)mp);
            } else {
                mimeMessage.setContent((Object)this.emailBodyTextHTML.toString(), "text/html; charset=UTF-8");
            }
            mimeMessage.setSentDate(new Date());
            try {
                Transport.send((Message)mimeMessage);
            }
            catch (SMTPSendFailedException ex) {
                _log.error("Error while trying to send emails");
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Failed to send the email message.", (Throwable)e);
        }
    }

    private static StringBuffer getWarningLegalText(boolean plainText) {
        StringBuffer toReturn = new StringBuffer();
        if (!plainText) {
            toReturn.append("<p>").append("<p><div style=\"color:#999999; font-size:10px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif; padding-top:15px;\">").append("WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain ").append("information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law. If you are not the intended recipient or the person responsible for delivering the message to the intended recipient, you are strictly prohibited from disclosing, distributing, copying, or in any way using this message. ").append("If you have received this communication in error, please notify the sender and destroy and delete any copies you may have received.").append("</div></p>");
        } else {
            toReturn.append("\n\n---------\n").append("WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain ").append("information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law. \n If you are not the intended recipient or the person responsible for delivering the message to the intended recipient, you are strictly prohibited from disclosing, distributing, copying, or in any way using this message. ").append("If you have received this communication in error, please notify the sender and destroy and delete any copies you may have received.");
        }
        return toReturn;
    }

    public String toString() {
        return "EmailNotification [emailrecipients=" + Arrays.toString(this.emailrecipients) + ", emailRecipientsInCC=" + String.valueOf(this.emailRecipientsInCC) + ", emailRecipientsInBCC=" + String.valueOf(this.emailRecipientsInBCC) + ", emailSubject=" + this.emailSubject + ", emailBodyTextHTML=" + String.valueOf(this.emailBodyTextHTML) + ", emailBodyTextPlain=" + String.valueOf(this.emailBodyTextPlain) + "]";
    }

    public static class EmailBuilder {
        private final String[] emailrecipients;
        private final String subject;
        private Template template;
        private String bodyTextHTML;
        private String bodyTextPlain;
        private List<InternetAddress> emailRecipientsInCC;
        private List<InternetAddress> emailRecipientsInBCC;
        private HttpServletRequest httpServletRequest;

        public EmailBuilder(String subject, HttpServletRequest httpServletRequest, String ... emailrecipients) {
            this.subject = subject;
            this.httpServletRequest = httpServletRequest;
            this.emailrecipients = emailrecipients;
            this.emailRecipientsInCC = new ArrayList<InternetAddress>();
            this.emailRecipientsInBCC = new ArrayList<InternetAddress>();
        }

        public EmailBuilder withTemplate(Template selectedTemplate) {
            this.template = selectedTemplate;
            return this;
        }

        public EmailBuilder contentTextHTML(String bodyTextHTML) {
            this.bodyTextHTML = bodyTextHTML;
            return this;
        }

        public EmailBuilder contentTextPlain(String bodyTextPlain) {
            this.bodyTextPlain = bodyTextPlain;
            return this;
        }

        public EmailBuilder cc(String ... cc) {
            for (String email : cc) {
                try {
                    this.emailRecipientsInCC.add(new InternetAddress(email));
                }
                catch (AddressException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        public EmailBuilder bcc(String ... bcc) {
            for (String email : bcc) {
                try {
                    this.emailRecipientsInBCC.add(new InternetAddress(email));
                }
                catch (AddressException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        public EmailNotification build() {
            EmailNotification email = new EmailNotification(this);
            this.validateUserObject(email);
            return email;
        }

        private void validateUserObject(EmailNotification email) {
            if (this.emailrecipients.length == 0) {
                throw new IllegalArgumentException("The array of email recipients cannot be empty");
            }
            if (this.template != null && (this.bodyTextHTML != null || this.bodyTextPlain != null)) {
                throw new IllegalArgumentException("Template is not null, but also the bodyText (plain or html) which one should I use?");
            }
        }
    }
}

