/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.resourcemanager.client;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.tools.resourcemanager.client.ResourceManagerClient;
import org.gcube.tools.resourcemanager.util.ParseDeploymentInformation;
import org.gcube.tools.resourcemanager.util.QueryInformationSystem;
import org.gcube.tools.resourcemanager.util.ServiceDeployment;
import org.gcube.tools.resourcemanager.util.Util;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.RemoveResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.service.ResourceManagerServiceAddressingLocator;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ResourceManager {
    private ResourceManagerPortType pt = null;
    private GCUBEScope scope = null;
    private QueryInformationSystem info = null;
    private ParseDeploymentInformation deploymentInfo;
    private String address = null;
    public int resourceManagerDelayMs = 900000;
    public int resourceManagerReportDelayMs = 30000;
    private static String RESOURCE_MANAGER_CLIENT_DELAY = "RESOURCE_MANAGER_CLIENT_DELAY";
    private static String RESOURCE_MANAGER_REPORT_DELAY = "RESOURCE_MANAGER_REPORT_DELAY";
    EndpointReferenceType epr = null;
    private String deploymentID;
    private String undeploymentID;
    GCUBELog logger = null;

    public String getDeploymentID() {
        return this.deploymentID;
    }

    public void setDeploymentID(String string) {
        this.deploymentID = string;
    }

    public String getUndeploymentID() {
        return this.undeploymentID;
    }

    public void setUndeploymentID(String string) {
        this.undeploymentID = string;
    }

    public ResourceManager(GCUBEScope gCUBEScope, String string) throws Exception {
        Properties properties = new Properties();
        properties.load(ResourceManager.class.getResourceAsStream("rm-log4j.properties"));
        this.logger = new GCUBEClientLog(ResourceManagerClient.class, new Properties[]{properties});
        this.scope = gCUBEScope;
        this.address = string;
        try {
            this.info = new QueryInformationSystem(gCUBEScope.toString());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            throw exception;
        }
        this.deploymentInfo = new ParseDeploymentInformation(this.info, this.logger);
        try {
            Properties properties2 = new Properties();
            properties2.load(ResourceManager.class.getResourceAsStream("resourcemanagerclientconf.properties"));
            this.resourceManagerDelayMs = new Integer((String)properties2.get(RESOURCE_MANAGER_CLIENT_DELAY)) * 1000;
            this.resourceManagerReportDelayMs = new Integer((String)properties2.get(RESOURCE_MANAGER_REPORT_DELAY)) * 1000;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error loading RMClient configuration", (Throwable)exception);
            throw exception;
        }
    }

    private void setResourceManagerPortType() throws IOException, GSSException, Exception {
        this.epr = this.address != "" ? this.info.getResourceManagerEndpoint() : new EndpointReferenceType(new Address(this.address));
        this.pt = new ResourceManagerServiceAddressingLocator().getResourceManagerPortTypePort(this.epr);
        this.pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.pt, (GCUBEScope)this.scope, (int)240000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
    }

    public String deployServices(ArrayList<ServiceDeployment> arrayList, GCUBEScope gCUBEScope) throws GCUBEFault, RemoteException {
        AddResourcesParameters addResourcesParameters = new AddResourcesParameters();
        try {
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            if (arrayList == null) {
                this.logger.error((Object)"The list of service to deploy contains a null value");
                return null;
            }
            ServiceItem[] serviceItemArray = new ServiceItem[new Integer(arrayList.size()).intValue()];
            for (int i = 1; i < serviceItemArray.length + 1; ++i) {
                if (arrayList.get(i - 1) == null) {
                    this.logger.error((Object)"The list of service to deploy contains a null value");
                    continue;
                }
                serviceItemArray[i - 1] = new ServiceItem();
                serviceItemArray[i - 1].setServiceClass(arrayList.get(i - 1).getServiceClass());
                serviceItemArray[i - 1].setServiceName(arrayList.get(i - 1).getServiceName());
                serviceItemArray[i - 1].setServiceVersion(arrayList.get(i - 1).getVersion());
                serviceItemArray[i - 1].setGHN(arrayList.get(i - 1).getGHN());
            }
            ServiceList serviceList = new ServiceList();
            serviceList.setService(serviceItemArray);
            addResourcesParameters.setServices(serviceList);
            addResourcesParameters.setTargetScope(gCUBEScope.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error((Object)exception);
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                this.deploymentID = this.pt.addResources(addResourcesParameters);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error((Object)exception);
            }
            if (this.deploymentID != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                this.logger.error((Object)interruptedException);
            }
        } while (this.deploymentID == null && System.currentTimeMillis() - l < (long)this.resourceManagerDelayMs);
        if (System.currentTimeMillis() - l > (long)this.resourceManagerDelayMs) {
            this.logger.error((Object)"Failed to contact the ResourceManager");
        }
        this.logger.info((Object)("Deployment ID :" + this.deploymentID));
        return this.deploymentID;
    }

    public String undeploySAs(ArrayList<ServiceDeployment> arrayList, GCUBEScope gCUBEScope) throws GCUBEFault, RemoteException {
        RemoveResourcesParameters removeResourcesParameters = new RemoveResourcesParameters();
        try {
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            ServiceItem[] serviceItemArray = new ServiceItem[arrayList.size()];
            for (int i = 1; i < serviceItemArray.length + 1; ++i) {
                serviceItemArray[i - 1] = new ServiceItem();
                serviceItemArray[i - 1].setServiceClass(arrayList.get(i - 1).getServiceClass());
                serviceItemArray[i - 1].setServiceName(arrayList.get(i - 1).getServiceName());
                serviceItemArray[i - 1].setServiceVersion(arrayList.get(i - 1).getVersion());
                if (arrayList.get(i - 1).getGHN() == null) continue;
                serviceItemArray[i - 1].setGHN(arrayList.get(i - 1).getGHN());
            }
            ServiceList serviceList = new ServiceList();
            serviceList.setService(serviceItemArray);
            removeResourcesParameters.setServices(serviceList);
            removeResourcesParameters.setTargetScope(gCUBEScope.toString());
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error creating RemoveSA request", (Throwable)exception);
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                this.undeploymentID = this.pt.removeResources(removeResourcesParameters);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error((Object)exception);
            }
            if (this.undeploymentID != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (this.undeploymentID == null && System.currentTimeMillis() - l < (long)this.resourceManagerDelayMs);
        if (System.currentTimeMillis() - l > (long)this.resourceManagerDelayMs) {
            this.logger.error((Object)"Failed to contact the ResourceManager");
        }
        this.logger.info((Object)("Undeployment ID :" + this.undeploymentID));
        return this.undeploymentID;
    }

    public ArrayList<ServiceDeployment> undeployRIs(String[] stringArray, boolean bl) throws GCUBEFault, RemoteException {
        RemoveResourcesParameters removeResourcesParameters = new RemoveResourcesParameters();
        ArrayList<ServiceDeployment> arrayList = null;
        try {
            if (bl) {
                arrayList = Util.checkRIs(stringArray, this.info, this.logger);
            }
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            ResourceItem[] resourceItemArray = new ResourceItem[stringArray.length];
            for (int i = 0; i < resourceItemArray.length; ++i) {
                resourceItemArray[i] = new ResourceItem();
                resourceItemArray[i].setID(stringArray[i]);
                resourceItemArray[i].setType("RunningInstance");
            }
            ResourceList resourceList = new ResourceList();
            resourceList.setResource(resourceItemArray);
            removeResourcesParameters.setResources(resourceList);
            removeResourcesParameters.setTargetScope(this.scope.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error((Object)"ERROR creating  ResourceManager request for undeployment", (Throwable)exception);
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                this.undeploymentID = this.pt.removeResources(removeResourcesParameters);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error((Object)exception);
            }
            if (this.undeploymentID != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (this.undeploymentID == null && System.currentTimeMillis() - l < (long)this.resourceManagerDelayMs);
        if (System.currentTimeMillis() - l > (long)this.resourceManagerDelayMs) {
            this.logger.error((Object)"Failed to contact the ResourceManager");
        }
        this.logger.info((Object)("Undeployment ID :" + this.undeploymentID));
        return arrayList;
    }

    public String addScope(String[] stringArray, String string, GCUBEScope gCUBEScope) {
        String string2 = null;
        AddResourcesParameters addResourcesParameters = new AddResourcesParameters();
        try {
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            ResourceItem[] resourceItemArray = new ResourceItem[stringArray.length];
            for (int i = 1; i < resourceItemArray.length + 1; ++i) {
                resourceItemArray[i - 1] = new ResourceItem();
                resourceItemArray[i - 1].setID(stringArray[i - 1]);
                resourceItemArray[i - 1].setType(string);
            }
            ResourceList resourceList = new ResourceList();
            resourceList.setResource(resourceItemArray);
            addResourcesParameters.setResources(resourceList);
            addResourcesParameters.setTargetScope(gCUBEScope.toString());
        }
        catch (Exception exception) {
            this.logger.error((Object)"ERROR creating AddScope request", (Throwable)exception);
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                string2 = this.pt.addResources(addResourcesParameters);
            }
            catch (Exception exception) {
                this.logger.error((Object)exception);
            }
            if (string2 != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                this.logger.error((Object)interruptedException);
            }
        } while (string2 == null && System.currentTimeMillis() - l < (long)this.resourceManagerDelayMs);
        if (System.currentTimeMillis() - l > (long)this.resourceManagerDelayMs) {
            this.logger.error((Object)"Failed to contact the ResourceManager");
        }
        this.logger.info((Object)("Report ID :" + string2));
        return string2;
    }

    public String removeScope(String[] stringArray, String string, GCUBEScope gCUBEScope) {
        String string2 = null;
        RemoveResourcesParameters removeResourcesParameters = new RemoveResourcesParameters();
        try {
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            ResourceItem[] resourceItemArray = new ResourceItem[stringArray.length];
            for (int i = 1; i < resourceItemArray.length + 1; ++i) {
                resourceItemArray[i - 1] = new ResourceItem();
                resourceItemArray[i - 1].setID(stringArray[i - 1]);
                resourceItemArray[i - 1].setType(string);
            }
            ResourceList resourceList = new ResourceList();
            resourceList.setResource(resourceItemArray);
            removeResourcesParameters.setResources(resourceList);
            removeResourcesParameters.setTargetScope(gCUBEScope.toString());
        }
        catch (Exception exception) {
            this.logger.error((Object)"ERROR creating removeScope request", (Throwable)exception);
            return null;
        }
        long l = System.currentTimeMillis();
        do {
            try {
                string2 = this.pt.removeResources(removeResourcesParameters);
            }
            catch (Exception exception) {
                this.logger.error((Object)exception);
            }
            if (string2 != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                this.logger.error((Object)interruptedException);
            }
        } while (string2 == null && System.currentTimeMillis() - l < (long)this.resourceManagerDelayMs);
        if (System.currentTimeMillis() - l > (long)this.resourceManagerDelayMs) {
            this.logger.error((Object)"Failed to contact the ResourceManager");
        }
        this.logger.info((Object)("reportID :" + string2));
        return string2;
    }

    public String getReport(String string, boolean bl) {
        String string2 = null;
        try {
            if (this.epr == null) {
                this.setResourceManagerPortType();
            }
            string2 = this.pt.getReport(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(document), streamResult);
            if (bl) {
                this.logger.info((Object)streamResult.getWriter().toString());
            } else {
                this.logger.debug((Object)streamResult.getWriter().toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error((Object)exception);
        }
        return string2;
    }

    public ParseDeploymentInformation getDeploymentInfo() {
        return this.deploymentInfo;
    }
}

