/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.mycontainer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.types.URI;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.mycontainer.Gar;
import org.gcube.common.mycontainer.GarDeployer;
import org.gcube.common.mycontainer.Utils;
import org.globus.wsrf.container.ServiceContainer;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AnyHelper;

public class MyContainer {
    private static Logger logger = Logger.getLogger(MyContainer.class);
    private GarDeployer deployer;
    boolean isRunning;
    File location;
    int port;
    long startupTimeout;
    Map<String, Gar> gars = new HashMap<String, Gar>();
    ServiceContainer globus;

    public MyContainer(Gar ... gars) throws IllegalStateException, IllegalArgumentException {
        this(new Properties(), true, gars);
    }

    public MyContainer(String location, Gar ... gars) throws IllegalStateException, IllegalArgumentException {
        this(MyContainer.properties(location), true, gars);
    }

    private static Properties properties(String location) {
        Properties props = new Properties();
        props.put("my-container.location", location);
        return props;
    }

    public MyContainer(Properties properties, Gar ... gars) throws IllegalArgumentException {
        this(properties, false, gars);
    }

    public MyContainer(Properties properties, boolean merge, Gar ... gars) throws IllegalArgumentException, IllegalStateException {
        String path;
        if (merge) {
            try {
                Properties common = Utils.findContainerProperties();
                common.putAll((Map<?, ?>)properties);
                properties = common;
            }
            catch (IllegalStateException e) {
                System.out.println("not using my-container.properties as none was found on the classpath");
            }
        }
        if ((path = (String)properties.get("my-container.location")) == null) {
            path = "my-container";
        }
        try {
            this.location = new File(path).getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Utils.checkDir(this.location);
        System.setProperty("GLOBUS_LOCATION", this.location.getAbsolutePath());
        try {
            this.addToEnvironment(this.location);
        }
        catch (Exception e) {
            throw new RuntimeException("could not add GLOBUS_LOCATION to environment ", e);
        }
        File logConfig = new File(this.location, "container-log4j.properties");
        if (logConfig.exists()) {
            try {
                PropertyConfigurator.configure((URL)logConfig.toURI().toURL());
            }
            catch (Exception e) {
                logger.warn((Object)("could not configure logging from " + logConfig));
            }
        }
        StringWriter report = new StringWriter();
        properties.list(new PrintWriter(report));
        logger.trace((Object)("configuring container in " + this.location + "\n" + report));
        String portprop = (String)properties.get("port");
        this.port = portprop == null ? 9999 : Integer.valueOf(portprop);
        String timeout = (String)properties.get("my-container.timeout");
        this.startupTimeout = timeout == null ? 15000L : Long.valueOf(timeout);
        File storageLocation = this.storageLocation();
        Utils.checkDir(storageLocation);
        System.setProperty("storage.root", storageLocation.getAbsolutePath());
        this.deployer = new GarDeployer(this);
        for (Gar gar : gars) {
            this.gars.put(gar.id(), gar);
        }
    }

    public File location() {
        return this.location;
    }

    public File storageLocation() {
        return new File(this.location, "store");
    }

    public File configLocation() {
        return new File(this.location, "config");
    }

    public File deploymentsLocation() {
        return new File(this.location, "etc");
    }

    public File libLocation() {
        return new File(this.location, "lib");
    }

    public <T> T endpoint(String name, Class<T> clazz) throws IllegalStateException {
        this.checkIsRunning();
        Object instance = this.globus.getEngine().getApplicationSession().get(name);
        if (instance == null) {
            throw new IllegalStateException("unknown port-type " + name);
        }
        return clazz.cast(instance);
    }

    public void setEndpoint(String name, Object endpoint) throws IllegalStateException {
        this.checkIsRunning();
        this.globus.getEngine().getApplicationSession().set(name, endpoint);
    }

    public URI address(String wsddName) throws IllegalStateException {
        return this.address(wsddName, 9999);
    }

    public URI address(String name, int port) throws IllegalStateException {
        this.checkIsRunning();
        this.endpoint(name, Object.class);
        return URI.create("http://localhost:" + port + "/wsrf/services/" + name);
    }

    public EndpointReferenceType reference(String name) throws IllegalStateException {
        return this.reference(name, this.port);
    }

    public EndpointReferenceType reference(String name, int port) throws IllegalStateException {
        this.checkIsRunning();
        this.endpoint(name, Object.class);
        try {
            AttributedURI uri = new AttributedURI(this.address(name).toString());
            EndpointReferenceType epr = new EndpointReferenceType();
            epr.setAddress(uri);
            return epr;
        }
        catch (URI.MalformedURIException e) {
            throw new RuntimeException(e);
        }
    }

    public EndpointReferenceType reference(String name, String namespace, String key) throws IllegalStateException {
        return this.reference(name, namespace, key, this.port);
    }

    public EndpointReferenceType reference(String name, String namespace, String key, int port) throws IllegalStateException {
        EndpointReferenceType epr = this.reference(name, port);
        SimpleResourceKey resourceKey = new SimpleResourceKey(new QName(namespace, "ResourceKey"), (Object)key);
        ReferencePropertiesType props = new ReferencePropertiesType();
        try {
            AnyHelper.setAny((AnyContentType)props, (SOAPElement)resourceKey.toSOAPElement());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        epr.setProperties(props);
        return epr;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        logger.trace((Object)("starting container in " + this.location));
        try {
            this.cleanState();
            this.deployGars();
            URL[] classpath = this.getClassPath();
            URLClassLoader loader = new URLClassLoader(classpath, MyContainer.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerClass = loader.loadClass(ServiceContainer.class.getName());
            Method createMethod = containerClass.getMethod("createContainer", Map.class);
            HashMap<String, Constable> props = new HashMap<String, Constable>();
            props.put("container.port", Integer.valueOf(this.port));
            props.put("container.mainThread", Boolean.valueOf(true));
            this.globus = (ServiceContainer)createMethod.invoke(containerClass, props);
            GHNContext ghn = GHNContext.getContext();
            Long start = System.currentTimeMillis();
            while (ghn.getStatus() != GHNContext.Status.CERTIFIED) {
                boolean noServices;
                Thread.sleep(200L);
                GHNContext.Status status = ghn.getStatus();
                if (status == GHNContext.Status.DOWN || status == GHNContext.Status.FAILED) {
                    throw new RuntimeException("could not start container successfully");
                }
                boolean bl = noServices = this.globus.getEngine().getApplicationSession().getKeys() == null;
                if (status == GHNContext.Status.READY && noServices) break;
                if (System.currentTimeMillis() - start <= this.startupTimeout) continue;
                throw new RuntimeException("could not start container in given time interval");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.stop();
            throw e;
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause != null) {
                Throwable innerCause = cause.getCause();
                if (innerCause != null) {
                    innerCause.printStackTrace();
                } else {
                    cause.printStackTrace();
                }
            } else {
                t.printStackTrace();
            }
            this.stop();
            throw new RuntimeException("could not start the container", t);
        }
        this.isRunning = true;
    }

    private void deployGars() {
        File[] currentDeployments;
        File undeploymentsDir = new File(this.deploymentsLocation(), "globus_packages");
        for (File deployment : currentDeployments = undeploymentsDir.exists() ? undeploymentsDir.listFiles() : new File[]{}) {
            if (this.gars.containsKey(deployment.getName())) continue;
            this.deployer.undeploy(deployment.getName());
        }
        block1: for (Gar gar : this.gars.values()) {
            for (File deployedGar : currentDeployments) {
                if (!deployedGar.getName().equals(gar.id()) || Utils.lastModified(deployedGar) <= gar.lastModified()) continue;
                logger.info((Object)("skipping deployment of " + gar.id() + " because it is unchanged"));
                continue block1;
            }
            logger.info((Object)("deploying Gar " + gar.id()));
            this.deployer.deploy(gar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        try {
            this.globus.stop();
            logger.trace((Object)("stopped container in " + this.location()));
        }
        catch (Throwable e) {
            logger.warn((Object)"could not stop container properly", e);
        }
        finally {
            this.isRunning = false;
        }
    }

    private void addToEnvironment(File location) throws Exception {
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        Map<String, String> env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map map = (Map)field.get(env);
            map.put("GLOBUS_LOCATION", location.getAbsolutePath());
        }
    }

    private URL[] getClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.location.toURI().toURL());
        File libs = this.libLocation();
        Utils.checkDir(libs);
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            File[] jars = libs.listFiles(filter);
            for (int i = 0; i < jars.length; ++i) {
                urls.add(jars[i].toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error during startup processing", e);
        }
        return urls.toArray(new URL[0]);
    }

    public void cleanState() {
        File defaultConfigLocation = new File(this.location, "defaultconfig");
        Utils.checkDir(defaultConfigLocation);
        try {
            if (this.configLocation().exists()) {
                FileUtils.cleanDirectory((File)this.configLocation());
            }
            FileUtils.copyDirectory((File)defaultConfigLocation, (File)this.configLocation());
        }
        catch (Exception e) {
            logger.error((Object)"could not restore default configuration");
        }
        try {
            if (this.storageLocation().exists()) {
                FileUtils.cleanDirectory((File)this.storageLocation());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.trace((Object)"cleaned container state");
    }

    private void checkIsRunning() throws IllegalStateException {
        if (!this.isRunning) {
            throw new IllegalStateException("container is not running");
        }
    }
}

