/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.mycontainer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.mycontainer.Utils;

public class Gar {
    File file;
    String id;
    List<File> libraries = new ArrayList<File>();
    List<File> interfaces = new ArrayList<File>();
    List<File> configurations = new ArrayList<File>();
    long lastModified;

    public Gar(File file) {
        this.file = this.addResource(file.getAbsolutePath(), false);
        this.id = file.getName().substring(0, file.getName().lastIndexOf("."));
    }

    public Gar(String id) {
        this.id = id;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public Gar addLibrary(String resourcePath) throws IllegalArgumentException {
        this.libraries.add(this.addResource(resourcePath, false));
        return this;
    }

    public Gar addLibraries(String resourcePath) throws IllegalArgumentException {
        return this.addResources(this.libraries, resourcePath);
    }

    public Gar addInterface(String resourcePath) throws IllegalArgumentException {
        this.libraries.add(this.addResource(resourcePath, false));
        return this;
    }

    public Gar addInterfaces(String resourcePath) throws IllegalArgumentException {
        return this.addResources(this.interfaces, resourcePath);
    }

    public Gar addConfiguration(String resourcePath) throws IllegalArgumentException {
        this.configurations.add(this.addResource(resourcePath, false));
        return this;
    }

    public Gar addConfigurations(String resourcePath) throws IllegalArgumentException {
        return this.addResources(this.configurations, resourcePath);
    }

    public String id() {
        return this.id;
    }

    public List<File> libs() {
        return this.libraries;
    }

    public List<File> interfaces() {
        return this.interfaces;
    }

    public List<File> configuration() {
        return this.configurations;
    }

    public File file() {
        return this.file;
    }

    private File addResource(String name, boolean dir) {
        if (this.file != null) {
            throw new IllegalStateException("Gar is already bound to " + this.file + " and cannot be further configured");
        }
        File file = new File(name);
        if (dir) {
            Utils.checkDir(file);
        } else {
            Utils.checkFile(file);
        }
        this.lastModified = Math.max(this.lastModified, Utils.lastModified(file));
        return file;
    }

    private Gar addResources(List<File> resources, String resourcePath) {
        for (File resource : this.addResource(resourcePath, true).listFiles()) {
            if (resource.isHidden()) continue;
            resources.add(this.addResource(resource.getAbsolutePath(), resource.isDirectory()));
        }
        return this;
    }
}

