/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.mycontainer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    static final String GLOBUS_LOCATION = "GLOBUS_LOCATION";
    public static final String CONTAINER_LOCATION_PROPERTY = "my-container.location";
    public static final String DEFAULT_INSTALL_DIRECTORY = "my-container";
    public static final String PROPERTY_FILE = "my-container.properties";
    public static final String STARTUP_TIMEOUT_PROPERTY = "my-container.timeout";
    public static final int DEFAULT_STARTUP_TIMEOUT = 15000;
    public static final String CONFIG_DIR = "config";
    public static final String ETC_DIR = "etc";
    public static final String LIB_DIR = "lib";
    public static final String STORAGE_DIR = "store";
    public static final String PORT_PROPERTY = "port";
    public static final int DEFAULT_PORT = 9999;
    static final String STORAGE_LOCATION_PROPERTY = "storage.root";

    public static Properties findContainerLocation() {
        logger.trace((Object)"locating installation of globus container...");
        File location = null;
        String path = System.getProperty(CONTAINER_LOCATION_PROPERTY);
        location = path != null ? new File(path) : new File(DEFAULT_INSTALL_DIRECTORY);
        if (!location.exists()) {
            location = new File(new File("").getAbsoluteFile().getParentFile(), DEFAULT_INSTALL_DIRECTORY);
        }
        if (!location.exists()) {
            location = new File(System.getProperty("user.home"), DEFAULT_INSTALL_DIRECTORY);
        }
        if (!location.exists()) {
            throw new RuntimeException("could not find install location");
        }
        Properties ps = new Properties();
        ps.setProperty(CONTAINER_LOCATION_PROPERTY, location.getAbsolutePath());
        return ps;
    }

    public static Properties findContainerProperties() throws IllegalStateException {
        logger.trace((Object)"locating my-container.properties to configure globus container");
        InputStream stream = Utils.class.getResourceAsStream("/my-container.properties");
        if (stream == null) {
            File file = new File(PROPERTY_FILE);
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"), PROPERTY_FILE);
            }
            if (file.exists()) {
                try {
                    stream = new FileInputStream(file);
                }
                catch (Exception swallow) {
                    // empty catch block
                }
            }
        }
        if (stream == null) {
            throw new IllegalStateException("could not find my-container.properties");
        }
        Properties ps = new Properties();
        try {
            ps.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("could not load container configuration", e);
        }
        return ps;
    }

    static void checkFile(File file) throws IllegalArgumentException {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead()) {
            throw new IllegalArgumentException(file + " is invalid, does not exist, is not a directory, or is not readable");
        }
    }

    static void checkDir(File dir) throws IllegalArgumentException {
        if (!(dir != null && dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite())) {
            throw new IllegalArgumentException(dir + " is invalid, does not exist, is not a directory, or is not readable");
        }
    }

    static long lastModified(File file) {
        if (file.isDirectory()) {
            long max = 0L;
            for (File inner : file.listFiles()) {
                max = Math.max(Utils.lastModified(inner), max);
            }
            return max;
        }
        return file.lastModified();
    }

    static File tempDir() throws IOException {
        File tmpDir = File.createTempFile("tmplibs", null);
        tmpDir.delete();
        if (!tmpDir.mkdirs()) {
            throw new IOException("cannot create temporary dir " + tmpDir);
        }
        return tmpDir;
    }
}

