/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.DefaultConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.AuthorizationException;
import org.gcube.spatial.data.geonetwork.model.faults.EncryptionException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingServiceEndpointException;
import org.gcube.spatial.data.geonetwork.utils.EncryptionUtils;
import org.gcube.tools.TokenSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceConfiguration
extends DefaultConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalResourceConfiguration.class);
    private final Object $lock = new Object[0];
    static String DEFAULT_FILENAME = "GeonetworkSE.xml";
    static ResourceConfiguration DEFAULT_RES_CONFIG = new ResourceConfiguration();
    private String fileName;

    static {
        DEFAULT_RES_CONFIG.setAdminPassword("admin");
        DEFAULT_RES_CONFIG.setVersion((short)2);
        DEFAULT_RES_CONFIG.setMinor((short)6);
        DEFAULT_RES_CONFIG.setRevision((short)1);
        DEFAULT_RES_CONFIG.setBuild((short)5);
        DEFAULT_RES_CONFIG.setHost("pc-fabio.isti.cnr.it");
        DEFAULT_RES_CONFIG.setEndpoint("http://pc-fabio.isti.cnr.it:8080/geonetwork");
    }

    public LocalResourceConfiguration(String fileName, ResourceConfiguration config) throws EncryptionException, MissingConfigurationException {
        this.fileName = fileName;
        log.debug("Checking file presence.. ");
        File f = new File(fileName);
        if (!f.exists()) {
            ServiceEndpoint toGenerate = new ServiceEndpoint();
            ServiceEndpoint.Profile profile = toGenerate.newProfile();
            profile.category(props.getProperty("geonetworkCategory"));
            profile.name(config.getName());
            profile.newPlatform().name(props.getProperty("geonetworkPlatformName")).version(config.getVersion()).buildVersion(config.getBuild()).minorVersion(config.getMinor()).revisionVersion(config.getRevision());
            profile.newRuntime().hostedOn(config.getHost()).status("READY");
            ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)profile.accessPoints().add();
            ap.credentials(EncryptionUtils.encrypt((String)config.getAdminPassword()), "admin");
            ap.name(props.getProperty("geonetworkEndpointName"));
            ap.address(config.getEndpoint());
            ap.properties().add((Object)new ServiceEndpoint.Property().nameAndValue(props.getProperty("priorityProperty"), "1"));
            log.debug("Storing generated resource..");
            this.update(toGenerate);
        }
    }

    protected List<ServiceEndpoint> doTheQuery(String geonetworkCategory, String geonetworkPlatformName) {
        Object object = this.$lock;
        synchronized (object) {
            try {
                return Collections.singletonList((ServiceEndpoint)Resources.unmarshal(ServiceEndpoint.class, (InputStream)new FileInputStream(new File(this.fileName))));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Unable to read from file system", e);
            }
        }
    }

    protected ServiceEndpoint update(ServiceEndpoint toStore) {
        try {
            File f = new File(this.fileName);
            Files.deleteIfExists(f.toPath());
            f.createNewFile();
            Resources.marshal((Object)toStore, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save ServiceEndpoint", e);
        }
        return toStore;
    }

    public static void main(String[] args) throws MissingConfigurationException, EncryptionException, MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException {
        String[] scopes;
        String[] stringArray = scopes = new String[]{"/gcube", "/gcube/devNext", "/gcube/devNext/NextNext"};
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            System.out.println("Scope : " + scope);
            TokenSetter.set(scope);
            GeoNetwork.get((Configuration)new LocalResourceConfiguration(DEFAULT_FILENAME, DEFAULT_RES_CONFIG));
            System.out.println("OK");
            ++n2;
        }
    }

    public static class ResourceConfiguration {
        private String name;
        private String endpoint;
        private String adminPassword;
        private short version = 0;
        private short minor = 0;
        private short revision = 0;
        private short build = 0;
        private String host;

        public String getName() {
            return this.name;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAdminPassword() {
            return this.adminPassword;
        }

        public short getVersion() {
            return this.version;
        }

        public short getMinor() {
            return this.minor;
        }

        public short getRevision() {
            return this.revision;
        }

        public short getBuild() {
            return this.build;
        }

        public String getHost() {
            return this.host;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAdminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
        }

        public void setVersion(short version) {
            this.version = version;
        }

        public void setMinor(short minor) {
            this.minor = minor;
        }

        public void setRevision(short revision) {
            this.revision = revision;
        }

        public void setBuild(short build) {
            this.build = build;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceConfiguration)) {
                return false;
            }
            ResourceConfiguration other = (ResourceConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$adminPassword = this.getAdminPassword();
            String other$adminPassword = other.getAdminPassword();
            if (this$adminPassword == null ? other$adminPassword != null : !this$adminPassword.equals(other$adminPassword)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getMinor() != other.getMinor()) {
                return false;
            }
            if (this.getRevision() != other.getRevision()) {
                return false;
            }
            if (this.getBuild() != other.getBuild()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $adminPassword = this.getAdminPassword();
            result = result * 59 + ($adminPassword == null ? 43 : $adminPassword.hashCode());
            result = result * 59 + this.getVersion();
            result = result * 59 + this.getMinor();
            result = result * 59 + this.getRevision();
            result = result * 59 + this.getBuild();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "LocalResourceConfiguration.ResourceConfiguration(name=" + this.getName() + ", endpoint=" + this.getEndpoint() + ", adminPassword=" + this.getAdminPassword() + ", version=" + this.getVersion() + ", minor=" + this.getMinor() + ", revision=" + this.getRevision() + ", build=" + this.getBuild() + ", host=" + this.getHost() + ")";
        }
    }
}

