/*
 * Decompiled with CFR 0.152.
 */
package org.etics.buildsystem.stub;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.etics.buildsystem.exception.ConfigurationException;
import org.etics.buildsystem.exception.DataAccessException;
import org.etics.buildsystem.exception.DeleteException;
import org.etics.buildsystem.exception.DuplicatedElementException;
import org.etics.buildsystem.exception.ElementFormatException;
import org.etics.buildsystem.exception.ElementNotFoundException;
import org.etics.buildsystem.exception.EticsSecurityException;
import org.etics.buildsystem.exception.InvalidDecreaseOperation;
import org.etics.buildsystem.exception.InvalidOperationException;
import org.etics.buildsystem.exception.InvalidParameterException;
import org.etics.buildsystem.exception.InvalidVersionFormatException;
import org.etics.buildsystem.exception.PlatformMismatchException;
import org.etics.buildsystem.exception.SubmissionTypeException;
import org.etics.buildsystem.exception.SubmitterException;
import org.etics.buildsystem.exception.VersioningConflictException;
import org.etics.buildsystem.operations.EticsOperation;
import org.etics.buildsystem.stub.AccountEntry;
import org.etics.buildsystem.stub.BuildCommand;
import org.etics.buildsystem.stub.Component;
import org.etics.buildsystem.stub.Configuration;
import org.etics.buildsystem.stub.EditOperation;
import org.etics.buildsystem.stub.Environment;
import org.etics.buildsystem.stub.EticsObject;
import org.etics.buildsystem.stub.EticsPackage;
import org.etics.buildsystem.stub.Job;
import org.etics.buildsystem.stub.JobStatus;
import org.etics.buildsystem.stub.Message;
import org.etics.buildsystem.stub.Module;
import org.etics.buildsystem.stub.Platform;
import org.etics.buildsystem.stub.Project;
import org.etics.buildsystem.stub.Property;
import org.etics.buildsystem.stub.Role;
import org.etics.buildsystem.stub.SchemaInfo;
import org.etics.buildsystem.stub.Store;
import org.etics.buildsystem.stub.Subsystem;
import org.etics.buildsystem.stub.TestCommand;
import org.etics.buildsystem.stub.User;
import org.etics.buildsystem.stub.UserRole;
import org.etics.buildsystem.stub.VcsCommand;

public interface BuildSystemService
extends Remote {
    public Message[] getMessage(String var1, String var2, String var3, int var4) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidParameterException;

    public void setMessage(String var1, String var2, String var3, String var4, String var5, boolean var6) throws RemoteException, DataAccessException, ElementFormatException, InvalidParameterException;

    public String getVersion() throws RemoteException;

    public Project[] listProjects() throws RemoteException, DataAccessException;

    public Component[] listProjectComponentsByName(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component[] listProjectComponentsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Subsystem[] listProjectSubsystemsByName(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Subsystem[] listProjectSubsystemsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public EticsPackage[] listComponentPackagesByName(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public EticsPackage[] listComponentPackagesById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component[] listSubsystemComponentsByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component[] listSubsystemComponentsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listProjectConfigurationsByName(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listProjectConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listSubsystemConfigurationsByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listSubsystemConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listComponentConfigurationsByName(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listComponentConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listPackageConfigurationsByName(String var1, String var2, String var3, String var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listPackageConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Module getModuleById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Module[] listModulesById(String[] var1) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidParameterException;

    public Module getModuleByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public EticsObject getModuleParent(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidOperationException;

    public Component getPackageParent(String var1) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidOperationException;

    public Configuration getPackageParentConfiguration(String var1) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidOperationException;

    public Project getProjectByName(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Project getProjectById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getProjectStructureByName(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getProjectStructureById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Subsystem getSubsystemByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Subsystem getSubsystemById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getSubsystemStructureById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component getComponentByName(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component getComponentFromProjectByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Component getComponentById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public EticsPackage getPackageById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public EticsPackage getPackageByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getConfigurationStructureById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getConfigurationStructureByIdWithoutChildren(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getConfigurationStructureByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getConfigurationStructureByIdByPlatformWithoutChildren(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration getConfigurationByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration getConfigurationByVersion(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException, VersioningConflictException, InvalidOperationException, InvalidVersionFormatException;

    public Configuration getConfigurationById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listConfigurationsById(String[] var1) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidParameterException;

    public Store traverseConfiguration(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getConfigurationByModuleName(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public User getUserById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Platform[] listPlatforms() throws RemoteException, DataAccessException;

    public Platform[] listMappedPlatforms() throws RemoteException, DataAccessException;

    public Configuration[] listDependentConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store listConfigurationDependencies(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store listConfigurationConfigurations(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listParentConfigurations(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public BuildCommand[] listConfigurationBuildCommandsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public BuildCommand listConfigurationBuildCommandsByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public TestCommand[] listConfigurationTestCommandsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public TestCommand listConfigurationTestCommandsByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public VcsCommand[] listConfigurationVcsCommandsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public VcsCommand listConfigurationVcsCommandsByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Environment[] listConfigurationEnvironmentsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Environment[] listConfigurationEnvironmentsByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Property[] listConfigurationPropertiesById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Property[] listConfigurationPropertiesByIdByPlatform(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Platform[] listConfigurationPlatformsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listSubConfigurationsById(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public SchemaInfo getSchemaInfo() throws RemoteException, DataAccessException;

    public Store getObjectById(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store getObjectByName(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Store listObjects(String var1) throws RemoteException, DataAccessException;

    public Job[] submit(String var1, String var2, String var3, String[] var4, String var5, String var6, String var7) throws RemoteException, ElementNotFoundException, DataAccessException, SubmissionTypeException, SubmitterException, DuplicatedElementException, PlatformMismatchException, EticsSecurityException, ConfigurationException;

    public void cancelJob(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException, EticsSecurityException, ConfigurationException;

    public Job[] submitSchedule(String var1, String var2, String var3, String[] var4, String var5, String var6, String var7, String var8, Calendar var9, Calendar var10) throws RemoteException, ElementNotFoundException, DataAccessException, SubmissionTypeException, SubmitterException, DuplicatedElementException, PlatformMismatchException, EticsSecurityException, ConfigurationException;

    public Job[] getUserJobs(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public JobStatus[] getJobStatus(String var1) throws RemoteException, ElementNotFoundException, DataAccessException, ConfigurationException;

    public Store createObjects(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException, ElementFormatException, DuplicatedElementException, InvalidOperationException;

    public Store cloneObject(String var1, String var2, String var3, String var4) throws RemoteException, ElementNotFoundException, DataAccessException, ElementFormatException, DuplicatedElementException, InvalidOperationException;

    public void saveObjects(Store var1) throws RemoteException, ElementNotFoundException, DataAccessException, ElementFormatException, DuplicatedElementException, InvalidOperationException, EticsSecurityException;

    public void updateObjects(Store var1) throws RemoteException, ElementNotFoundException, DataAccessException, ElementFormatException, InvalidOperationException, EticsSecurityException;

    public void deleteObject(Store var1, boolean var2) throws RemoteException, ElementNotFoundException, DeleteException, DataAccessException, EticsSecurityException;

    public void deletePlatformSupport(String var1, String var2) throws RemoteException, DeleteException, ElementNotFoundException, DataAccessException, EticsSecurityException;

    public Store linkObjects(String var1, String var2, String var3, String var4) throws RemoteException, InvalidOperationException;

    public void executeTransaction(EditOperation[] var1) throws RemoteException, DeleteException, DataAccessException, ElementFormatException, DuplicatedElementException, InvalidOperationException, EticsSecurityException;

    public User getUserByDN(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Role[] getUserRoles(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException, EticsSecurityException;

    public EticsOperation[] getUserOperations(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException, EticsSecurityException;

    public boolean isETICSAdministrator(String var1) throws RemoteException, ElementNotFoundException, DataAccessException, EticsSecurityException;

    public void activateUser(String var1) throws RemoteException, ElementNotFoundException, DataAccessException;

    public User[] listUsers() throws RemoteException, DataAccessException, EticsSecurityException;

    public Role[] listRoles() throws RemoteException, DataAccessException;

    public UserRole[] listDirectUserRoles(String var1) throws RemoteException, DataAccessException, InvalidParameterException, EticsSecurityException;

    public AccountEntry[] readAccountEntries(String var1, String var2, String var3, String var4, String var5, String var6, Calendar var7, Calendar var8, int var9) throws RemoteException, DataAccessException, InvalidParameterException;

    public int decrementCounter(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidDecreaseOperation;

    public void lockConfiguration(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidOperationException, EticsSecurityException, InvalidVersionFormatException;

    public void unlockConfiguration(String var1) throws RemoteException, ElementNotFoundException, DataAccessException, InvalidOperationException, EticsSecurityException;

    public String getBackendStatus() throws RemoteException, DataAccessException;

    public Job[] getJobsByProject(Project var1, String var2, Calendar var3, Calendar var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Job[] getJobsBySubsystem(Subsystem var1, String var2, Calendar var3, Calendar var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Job[] getJobsByComponent(Component var1, String var2, Calendar var3, Calendar var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Job[] getJobsByPackage(EticsPackage var1, String var2, Calendar var3, Calendar var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Job[] getJobsByConfiguration(Configuration var1, String var2, Calendar var3, Calendar var4) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Module[] searchModules(String var1, int var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public Configuration[] listModuleConfigurationsByName(String var1) throws RemoteException, DataAccessException;

    public String getConfigurationDiff(String var1, String var2) throws RemoteException, ElementNotFoundException, DataAccessException;

    public String getConfigurationPlatformDiff(String var1, String var2, String var3) throws RemoteException, ElementNotFoundException, DataAccessException;

    public String[] listSubmitters() throws RemoteException, ConfigurationException;

    public String getObjectHistory(String var1) throws RemoteException, DataAccessException;
}

