/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextraction.utils;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.is.InformationSystem;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.execution.workflowengine.service.stubs.AccessInfo;
import org.gcube.execution.workflowengine.service.stubs.JDLConfig;
import org.gcube.execution.workflowengine.service.stubs.JDLParams;
import org.gcube.execution.workflowengine.service.stubs.JDLResource;
import org.gcube.execution.workflowengine.service.stubs.JobOutput;
import org.gcube.execution.workflowengine.service.stubs.StatusReport;
import org.gcube.execution.workflowengine.service.stubs.StatusRequest;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;
import org.gcube.textextraction.TextExtractionJobControllerResource;
import org.gcube.textextraction.exceptions.JobStatusRetrievalException;
import org.gcube.textextraction.exceptions.NoScriptFoundException;
import org.gcube.textextraction.exceptions.NoWorkflowEngineEPRFound;
import org.gcube.textextraction.exceptions.NodeWithTextExtractionSoftwareNotFoundException;
import org.gcube.textextraction.exceptions.WorkflowEnginePortTypeException;
import org.gcube.textextraction.utils.ServiceUtils;

public class JobSubmissionUtils {
    static GCUBELog logger = new GCUBELog(TextExtractionJobControllerResource.class);
    static final String mainClass = "org.gcube.execution.textExtraction.job.TextExtractionJob";

    public static String createAndSubmitJob(String servletURI, String queryToSubmit, String ftpHost, String ftpFolder, String scope, String dtsInputCollectionId, String ftpUser, String ftpPassword, String ftpPort, String suggestedDTSEpr, String suggestedOCREpr, ArrayList<String> engineUrlToFill) throws NoScriptFoundException, EnvironmentInformationSystemException, IOException, NodeWithTextExtractionSoftwareNotFoundException, NoWorkflowEngineEPRFound, WorkflowEnginePortTypeException {
        WorkflowEngineServicePortType wf;
        String endpoint;
        String outReference;
        String outAccess;
        AccessInfo ftpAccess;
        JDLParams params = new JDLParams();
        JDLConfig conf = new JDLConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        params.setConfig(conf);
        JDLResource r = null;
        ArrayList<JDLResource> resourceslst = null;
        EnvHintCollection hints = new EnvHintCollection();
        hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(scope)));
        String[] parsedFolder = ftpFolder.split("/");
        String repositoryId = parsedFolder[parsedFolder.length - 1];
        if (InformationSystem.GetMatchingNode(null, (String)"software.textextraction == true", (EnvHintCollection)hints) != null) {
            logger.debug((Object)("A node with TextExtractionJob was found in scope: " + scope));
            ftpAccess = new AccessInfo();
            outAccess = "CMSReference";
            outReference = "";
            ftpAccess.setPassword(ftpPassword.trim());
            ftpAccess.setPort(ftpPort);
            ftpAccess.setUserId(ftpUser.trim());
            outAccess = "Reference";
            outReference = "ftp://" + ftpHost + "/" + repositoryId + "/jobsOutput";
            logger.debug((Object)("We set ftp folder output to Workflow Engine: " + outReference));
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"textExtractionJob.sh\";\nArguments = \"" + mainClass.replaceAll("//", "__") + " " + servletURI.replaceAll("//", "__") + " " + queryToSubmit.replaceAll("//", "__").replaceAll(" ", "_space_") + " " + ftpHost.replaceAll("//", "__") + " " + ftpFolder.replaceAll("//", "__") + " " + scope.replaceAll("//", "__") + " " + dtsInputCollectionId.replaceAll("//", "__") + " " + ftpUser.replaceAll("//", "__") + " " + ftpPassword.replaceAll("//", "__") + " " + ftpPort.replaceAll("//", "__") + " " + suggestedDTSEpr.replaceAll("//", "__") + " " + suggestedOCREpr.replaceAll("//", "__") + "\";\n" + "StdOutput = \"job.out\";\n" + "StdError = \"job.err\";\n" + "VirtualOrganisation = \"d4science.research-infrastructures.eu\";\n" + "InputSandbox = {" + "\"textExtractionJob.sh\"};\n" + "OutputSandbox = {\"job.out\", \"job.err\"};\n" + "Environment = {\"CLASSPATH=$GLOBUS_LOCATION/lib\"};\n" + "Requirements = software.textextraction == true  ;\n" + "]\n";
            logger.debug((Object)("------> Sed jdl of TextExtraction job: \n" + jdlDescription));
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList<JDLResource>();
            String textExtractionJobShFileName = System.getenv("GLOBUS_LOCATION") + "/textExtractionJob.sh";
            if (!ServiceUtils.fileExists(textExtractionJobShFileName)) {
                throw new NoScriptFoundException("textExtractionJob.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r = new JDLResource();
            r.setResourceKey("textExtractionJob.sh");
            r.setResourceAccess("InMessageString");
            r.setInMessageStringPayload(ServiceUtils.GetStringFilePayload(textExtractionJobShFileName));
            resourceslst.add(r);
        } else {
            throw new NodeWithTextExtractionSoftwareNotFoundException("No node with textExtraction software found for this scope!");
        }
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.out");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.err");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        JDLResource[] jdlResourceArray = new JDLResource[resourceslst.size()];
        params.setJdlResources(resourceslst.toArray(jdlResourceArray));
        for (int p = 0; p < params.getJdlResources().length; ++p) {
            logger.debug((Object)(" Resource " + p + " Key:" + params.getJdlResources()[p].getResourceKey() + " Access:" + params.getJdlResources()[p].getResourceAccess() + " Ref:" + params.getJdlResources()[p].getResourceReference() + " String:" + params.getJdlResources()[p].getInMessageStringPayload()));
        }
        logger.info((Object)"Locating Workflow Engine to submit TextExtraction job");
        String Scope = scope;
        try {
            endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
            engineUrlToFill.add(0, endpoint);
        }
        catch (Exception e) {
            logger.error((Object)"Now WorkflowEngine epr found.", (Throwable)e);
            throw new NoWorkflowEngineEPRFound(e);
        }
        System.out.println("Selected Workflow Engine for TextExtraction job: " + endpoint);
        logger.info((Object)("Submitting TextExtraction job to Workflow Engine (scope:" + scope + " , endpoint:" + endpoint));
        try {
            wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
        }
        catch (Exception e) {
            logger.error((Object)"Problem when retrieving WorkFlowEnginePortType", (Throwable)e);
            throw new WorkflowEnginePortTypeException(e);
        }
        String executionId = wf.adaptJDL(params);
        System.out.println("Submitted TextExtraction job successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")");
        return executionId;
    }

    public static String getJobStatus(String executionId, String scope, String engineUrl) throws WorkflowEnginePortTypeException, JobStatusRetrievalException {
        WorkflowEngineServicePortType wf;
        try {
            logger.debug((Object)("getJobStatus scope:" + scope + " executionId: " + executionId));
            wf = ServiceUtils.GetWorkflowEnginePortType(scope, engineUrl);
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting WorkflowEnginePortType to poll status of OCR job", (Throwable)e);
            throw new WorkflowEnginePortTypeException(e);
        }
        StatusRequest req = new StatusRequest();
        req.setExecutionID(executionId);
        req.setIncludePlan(Boolean.valueOf(false));
        StatusReport rep = null;
        try {
            rep = wf.executionStatus(req);
        }
        catch (RemoteException e) {
            logger.debug((Object)("Error while asking status of job: " + executionId), (Throwable)e);
            throw new JobStatusRetrievalException(e);
        }
        if (rep.isIsCompleted()) {
            if (rep.getError() != null && !rep.getError().equals("") || rep.getErrorDetails() != null && !rep.getErrorDetails().equals("")) {
                logger.debug((Object)("JOB_FINISHED WITH ERROR: " + rep.getError()));
                return "TORESUBMIT";
            }
            for (JobOutput jo : rep.getOutput()) {
                if (jo.getKey() == null || jo.getKey().trim().length() <= 0) continue;
                if (jo.getKey().equals("job.out")) {
                    logger.debug((Object)("The job out is: " + jo.getStorageSystemID()));
                    continue;
                }
                if (!jo.getKey().equals("job.err")) continue;
                logger.debug((Object)("The job error is: " + jo.getStorageSystemID()));
            }
            return "COMPLETED";
        }
        return "RUNNING";
    }
}

