/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextraction;

import java.rmi.RemoteException;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.textextraction.ServiceContext;
import org.gcube.textextraction.StatefulContext;
import org.gcube.textextraction.TextExtractionJobControllerResource;
import org.gcube.textextraction.stubs.CreateResource;
import org.gcube.textextraction.stubs.CreateResourceResponse;

public class TextExtractionJobControllerFactory
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog(TextExtractionJobControllerFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        try {
            this.logger.debug((Object)("CreateResource called... with params: " + request.getRepositoryID() + ", " + request.getServletURI() + ", " + request.getDTSInputCollectionID() + ", " + request.getFTPLocationDirectory() + ", " + request.getQueryToSubmit() + ", " + request.getRepositoryNumberOfRecords() + ", " + request.getFTPHost() + ", " + request.getBatchSize()));
            CreateResourceResponse response = this.create(request.getRepositoryID(), request.getServletURI(), request.getDTSInputCollectionID(), request.getFTPLocationDirectory(), request.getQueryToSubmit(), request.getRepositoryNumberOfRecords(), request.getFTPHost(), request.getBatchSize());
            return response;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to create lookup resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[]{"*** In LookupFactoryService.createResource ***"});
        }
    }

    private CreateResourceResponse create(String repositoryID, String servletURI, String dtsInputCollectionID, String ftpLocation, String queryToSubmit, int repositoryNumberOfRecords, String ftpHost, int batchSize) throws RemoteException {
        TextExtractionJobControllerResource resource = null;
        CreateResourceResponse response = new CreateResourceResponse();
        try {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            GCUBEWSResourceKey key = ptctx.makeKey(uuidGen.nextUUID());
            resource = (TextExtractionJobControllerResource)ptctx.getWSHome().create(key, new Object[]{key, repositoryID, servletURI, dtsInputCollectionID, ftpLocation, queryToSubmit, repositoryNumberOfRecords, ftpHost, batchSize});
            response.setEndpointReference(resource.getEPR());
            resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"*** Unable to create lookup resource ***", (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{" *** Unable to create lookup resource *** " + e.getMessage()});
        }
        return response;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

