package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.Date;
import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public interface Task extends Job {

	public TaskId getId();

	public List<TaskJob> getTaskJobs();

	public Date getStartTime();

	public Date getEndTime();

	public String getInvokerUsername();
	
	public List<TabularResourceId> getCollateralTabularResourceIds();

	public void abort();

	public static class TaskId {

		private String value;

		public TaskId(String value) {
			this.value = value;
		}

		public String getValue() {
			return value;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#hashCode()
		 */
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((value == null) ? 0 : value.hashCode());
			return result;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#equals(java.lang.Object)
		 */
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			TaskId other = (TaskId) obj;
			if (value == null) {
				if (other.value != null)
					return false;
			} else if (!value.equals(other.value))
				return false;
			return true;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return "TaskId [value=" + value + "]";
		}
		
	}

}
