package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.operation.Task.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public interface OperationInterface {
	
	public List<EligibleOperation> getCapabilities();

	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException;

	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId) throws NoSuchTabularResourceException, InvalidTabularResourceException, NoSuchColumnException;

	public Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException;
	
	public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId) throws NoSuchTabularResourceException, NoSuchTableException;
	 
	public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException;
	
	public Task getTask(TaskId operationId, TabularResourceId tabularResourceId) throws NoSuchTaskException, NoSuchTabularResourceException;
	
}
