/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.commons.io.IOUtils;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.faults.UnableToLockException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commons {
    private static final Logger log = LoggerFactory.getLogger(Commons.class);
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yy:HH:mm:SS");

    public static void cleanupFolder(String toCleanPath, String destinationToken) {
        throw new RuntimeException("ILLEGAL OPERATION");
    }

    public static String getThreddsHost() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'SDI'").addCondition("$resource/Profile/ServiceName/text() eq 'Thredds'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        GCoreEndpoint endpoint = (GCoreEndpoint)client.submit((Query)query).get(0);
        return ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().iterator().next()).uri().getHost();
    }

    public static DataTransferClient getDTClient(String threddsHostName) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting DT Client for {} ", (Object)threddsHostName);
        return DataTransferClient.getInstanceByEndpoint((String)("https://" + threddsHostName));
    }

    public static String readThreddsFile(String location) throws RemoteFileNotFoundException {
        String urlString = "https://" + Commons.getThreddsHost() + "/" + "data-transfer-service/gcube/service/REST/thredds/" + location;
        log.info("Reading file at {} ", (Object)urlString);
        try {
            return (String)Commons.getWebClient().target(urlString).request().get().readEntity(String.class);
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
    }

    public static void deleteThreddsFile(String location) throws RemoteFileNotFoundException {
        String urlString = "https://" + Commons.getThreddsHost() + "/" + "data-transfer-service/gcube/service/REST/thredds/" + location;
        log.info("Reading file at {} ", (Object)urlString);
        try {
            Commons.getWebClient().target(urlString).request().delete();
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
    }

    public static final ThreddsInfo getThreddsInfo() {
        String infoPath = Commons.getThreddsInfoPath();
        log.info("Loading thredds info from {} ", (Object)infoPath);
        WebTarget target = Commons.getWebClient().target(infoPath);
        return (ThreddsInfo)target.request(new String[]{"application/json"}).get(ThreddsInfo.class);
    }

    private static Client getWebClient() {
        return ClientBuilder.newClient((Configuration)new ClientConfig().register(AuthorizationFilter.class));
    }

    private static String getThreddsInfoPath() {
        return "httpss://" + Commons.getThreddsHost() + "/data-transfer-service/gcube/service/Capabilities/pluginInfo/REGISTER_CATALOG";
    }

    public static void lockFolder(String folderPath, String processId) throws UnableToLockException {
        File temp;
        block11: {
            PrintWriter writer = null;
            temp = null;
            try {
                log.info("Locking remote path {} to processId {} ", (Object)folderPath, (Object)processId);
                DataTransferClient cl = Commons.getDTClient(Commons.getThreddsHost());
                Destination dest = new Destination();
                dest.setCreateSubfolders(Boolean.valueOf(false));
                dest.setOnExistingFileName(DestinationClashPolicy.FAIL);
                dest.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
                dest.setPersistenceId("thredds");
                dest.setSubFolder(folderPath);
                dest.setDestinationFileName("~WS-LOCK.lock");
                temp = File.createTempFile("tmp_lock", ".tmp");
                writer = new PrintWriter(temp);
                writer.write(processId);
                writer.flush();
                writer.close();
                cl.localFile(temp, dest);
                if (writer == null) break block11;
            }
            catch (Throwable t) {
                try {
                    throw new UnableToLockException("Unable to lock " + folderPath, t);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        IOUtils.closeQuietly(writer);
                    }
                    if (temp != null) {
                        try {
                            Files.deleteIfExists(temp.toPath());
                        }
                        catch (IOException e) {
                            log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
                        }
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        if (temp != null) {
            try {
                Files.deleteIfExists(temp.toPath());
            }
            catch (IOException e) {
                log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
            }
        }
    }
}

