/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.gcube.usecases.ws.thredds.FolderConfiguration;
import org.gcube.usecases.ws.thredds.engine.PublishReport;
import org.gcube.usecases.ws.thredds.engine.PublishRequest;
import org.gcube.usecases.ws.thredds.engine.PublishThread;

public class TransferRequestServer {
    private final Object $lock = new Object[0];
    private Report report = new Report();
    private ExecutorService service = null;

    public TransferRequestServer() {
        LinkedBlockingDeque<Runnable> linkedBlockingDeque = new LinkedBlockingDeque<Runnable>(100);
        this.service = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, linkedBlockingDeque, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void put(PublishRequest request) {
        System.out.println("Submitting transfer " + this.getReport().requestCount.incrementAndGet());
        this.service.execute(new PublishThread(request, this.getReport().getReports()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReport() {
        Object object = this.$lock;
        synchronized (object) {
            return this.report;
        }
    }

    public void waitCompletion() {
        boolean running = true;
        this.service.shutdown();
        while (running) {
            System.out.println("******************* WAITING FOR TERMINATION ***************** ");
            try {
                running = !this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                running = !this.service.isTerminated();
            }
        }
        System.out.println("Service is completed : " + this.service.isTerminated());
    }

    public static class Report {
        private AtomicLong requestCount = new AtomicLong(0L);
        private AtomicLong requestServed = new AtomicLong(0L);
        private ConcurrentHashMap<String, PublishReport> reports = new ConcurrentHashMap();

        public File toFile(FolderConfiguration configuration) {
            return Report.toFile(configuration, this);
        }

        private static final File toFile(FolderConfiguration config, Report report) {
            File file;
            block8: {
                PrintWriter writer = null;
                try {
                    File toReturn = File.createTempFile("tempFile", ".tmp");
                    writer = new PrintWriter(toReturn);
                    writer.println("REPORT FOR WS-SYNCH");
                    writer.println("Configuratiion was : " + config);
                    writer.println("Submitted runs : " + report.getRequestCount());
                    writer.println("Item reports : ");
                    for (Map.Entry<String, PublishReport> entry : report.getReports().entrySet()) {
                        PublishReport rep = entry.getValue();
                        writer.println("*********************************************************");
                        if (rep.isError()) {
                            writer.println("OPERATION IS FAILED");
                        }
                        writer.println("ITEM ID : " + rep.getSourceId());
                        writer.println("ITEM NAME : " + rep.getSourceName());
                        if (rep.getTransferResult() != null) {
                            writer.println("Transfer report : " + rep.getTransferResult());
                        }
                        if (rep.getMetadataReport() == null) continue;
                        writer.println("Metadata report : " + rep.getMetadataReport());
                    }
                    file = toReturn;
                    if (writer == null) break block8;
                }
                catch (Throwable t) {
                    try {
                        throw new RuntimeException(t);
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            IOUtils.closeQuietly(writer);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)writer);
            }
            return file;
        }

        public AtomicLong getRequestCount() {
            return this.requestCount;
        }

        public AtomicLong getRequestServed() {
            return this.requestServed;
        }

        public ConcurrentHashMap<String, PublishReport> getReports() {
            return this.reports;
        }

        public void setRequestCount(AtomicLong requestCount) {
            this.requestCount = requestCount;
        }

        public void setRequestServed(AtomicLong requestServed) {
            this.requestServed = requestServed;
        }

        public void setReports(ConcurrentHashMap<String, PublishReport> reports) {
            this.reports = reports;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Report)) {
                return false;
            }
            Report other = (Report)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtomicLong this$requestCount = this.getRequestCount();
            AtomicLong other$requestCount = other.getRequestCount();
            if (this$requestCount == null ? other$requestCount != null : !this$requestCount.equals(other$requestCount)) {
                return false;
            }
            AtomicLong this$requestServed = this.getRequestServed();
            AtomicLong other$requestServed = other.getRequestServed();
            if (this$requestServed == null ? other$requestServed != null : !this$requestServed.equals(other$requestServed)) {
                return false;
            }
            ConcurrentHashMap<String, PublishReport> this$reports = this.getReports();
            ConcurrentHashMap<String, PublishReport> other$reports = other.getReports();
            return !(this$reports == null ? other$reports != null : !((Object)this$reports).equals(other$reports));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Report;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicLong $requestCount = this.getRequestCount();
            result = result * 59 + ($requestCount == null ? 0 : $requestCount.hashCode());
            AtomicLong $requestServed = this.getRequestServed();
            result = result * 59 + ($requestServed == null ? 0 : $requestServed.hashCode());
            ConcurrentHashMap<String, PublishReport> $reports = this.getReports();
            result = result * 59 + ($reports == null ? 0 : ((Object)$reports).hashCode());
            return result;
        }

        public String toString() {
            return "TransferRequestServer.Report(requestCount=" + this.getRequestCount() + ", requestServed=" + this.getRequestServed() + ", reports=" + this.getReports() + ")";
        }
    }
}

