/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds;

import java.util.Properties;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSetter {
    private static final Logger log = LoggerFactory.getLogger(TokenSetter.class);
    private static Properties props = null;

    public static synchronized void set(String scope) {
        try {
            if (props == null) {
                props = new Properties();
                try {
                    props.load(TokenSetter.class.getResourceAsStream("/tokens.properties"));
                }
                catch (Exception e) {
                    throw new RuntimeException("YOU NEED TO SET TOKEN FILE IN CONFIGURATION");
                }
            }
            if (!props.containsKey(scope)) {
                throw new Exception("No token found for scope : " + scope);
            }
            SecurityTokenProvider.instance.set(props.getProperty(scope));
        }
        catch (Throwable e) {
            log.trace("Unable to set token for scope " + scope, e);
        }
        ScopeProvider.instance.set(scope);
    }

    public static void setToken(String token) {
        try {
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            ScopeProvider.instance.set(entry.getContext());
            SecurityTokenProvider.instance.set(token);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set token " + token, t);
        }
    }

    public static String getCurrentToken() {
        return SecurityTokenProvider.instance.get();
    }
}

