/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.nodes.accounting.AccountEntry;
import org.gcube.common.storagehub.model.items.nodes.accounting.AccountFolderEntryRemoval;
import org.gcube.common.storagehub.model.items.nodes.accounting.AccountFolderEntryRenaming;
import org.gcube.common.storagehub.model.types.WorkspaceItemType;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.usecases.ws.thredds.Constants;
import org.gcube.usecases.ws.thredds.engine.impl.Process;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.threads.DeleteRemoteRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationThread;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.model.StepReport;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceUtils.class);

    public static StorageHubClient getClient() throws StorageHubException {
        return new StorageHubClient();
    }

    static Set<String> scanAccountingForStatus(FolderContainer toScanFolder, SynchFolderConfiguration config, Set<String> localChildrenNames, Set<String> remoteChildrenNames, ThreddsController folderController, Process ownerProcess, ExecutorService service) throws StorageHubException {
        HashSet<String> handledAccountingEntries = new HashSet<String>();
        FolderItem toScanFolderItem = (FolderItem)toScanFolder.get();
        log.debug("Checking history of {} ", (Object)toScanFolderItem.getPath());
        String relativePath = "" + toScanFolderItem.getMetadata().getMap().get("WS-SYNCH.REMOTE-PATH");
        Date folderLastUpdateTime = null;
        try {
            folderLastUpdateTime = WorkspaceUtils.safelyGetLastUpdate((Item)toScanFolderItem);
        }
        catch (Throwable t) {
            log.warn("Unable to get folder {} last update time. Assuming first run.. ", (Object)toScanFolderItem.getName(), (Object)t);
            folderLastUpdateTime = new Date(0L);
        }
        log.debug("Checking Accounting for {}. Last update time is {} ", (Object)toScanFolderItem.getName(), (Object)Constants.DATE_FORMAT.format(folderLastUpdateTime));
        for (AccountEntry entry : toScanFolderItem.getAccounting().getEntries()) {
            try {
                Date eventTime = entry.getDate().getTime();
                if (folderLastUpdateTime != null && !eventTime.after(folderLastUpdateTime)) continue;
                String toDeleteRemote = null;
                switch (entry.getType()) {
                    case CUT: 
                    case REMOVAL: {
                        AccountFolderEntryRemoval removalEntry = (AccountFolderEntryRemoval)entry;
                        if (!removalEntry.getItemType().equals(WorkspaceItemType.FOLDER.toString()) && !config.matchesFilter(removalEntry.getItemName())) break;
                        toDeleteRemote = removalEntry.getItemName();
                        break;
                    }
                    case RENAMING: {
                        AccountFolderEntryRenaming renamingEntry = (AccountFolderEntryRenaming)entry;
                        ItemContainer newItem = (ItemContainer)toScanFolder.findByName(renamingEntry.getNewItemName()).getContainers().get(0);
                        if (!newItem.getType().equals((Object)ContainerType.FOLDER) && !config.matchesFilter(renamingEntry.getOldItemName())) break;
                        toDeleteRemote = renamingEntry.getOldItemName();
                        break;
                    }
                    default: {
                        log.debug("Skpping accounting entry {} ", (Object)entry.getType());
                    }
                }
                if (toDeleteRemote == null) continue;
                if (localChildrenNames.contains(toDeleteRemote)) {
                    log.debug("Skipping accounting entry for existing local item {} ", (Object)toDeleteRemote);
                    continue;
                }
                if (remoteChildrenNames.contains(toDeleteRemote)) {
                    log.debug("Checking age of remote {} ", (Object)toDeleteRemote);
                    RemoteFileDescriptor remote = folderController.getFileDescriptor(String.valueOf(relativePath) + "/" + toDeleteRemote);
                    Date remoteDate = new Date(remote.getLastUpdate());
                    log.debug("Last remote update : {} . Event date {}  ", (Object)Constants.DATE_FORMAT.format(remoteDate), (Object)Constants.DATE_FORMAT.format(eventTime));
                    if (service == null) continue;
                    log.debug("Service is not null. Submitting request ... ");
                    if (!eventTime.after(remoteDate)) continue;
                    service.execute(new SynchronizationThread(new DeleteRemoteRequest(ownerProcess, toScanFolderItem, toDeleteRemote)));
                    handledAccountingEntries.add(toDeleteRemote);
                    log.debug("Submitted DELETION request number {} ", (Object)ownerProcess.getStatus().getQueuedTransfers().incrementAndGet());
                    continue;
                }
                log.debug("To delete remote {} not found. skipping it.. ", (Object)toDeleteRemote);
            }
            catch (Throwable t) {
                log.error("Unable to submit deletion request for {} ", (Object)entry, (Object)t);
            }
        }
        return handledAccountingEntries;
    }

    static Set<String> scanRemoteFolder(RemoteFileDescriptor folderDesc, Set<String> handledAccountingEntries, Set<String> handledWorkspaceItemEntries, FolderContainer toScanFolder, ThreddsController folderController, SynchFolderConfiguration config, Process ownerProcess, ExecutorService service) throws InternalException, StorageHubException {
        FolderItem toScanItem = (FolderItem)toScanFolder.get();
        log.debug("Checking remote content for {}. Remote Absolute Path is {} ", (Object)toScanItem.getPath(), (Object)folderDesc.getAbsolutePath());
        HashSet<String> handledRemoteElements = new HashSet<String>();
        if (!folderDesc.isDirectory()) {
            throw new InternalException("Remote Descriptor " + folderDesc.getAbsolutePath() + " Is not a directory. ");
        }
        for (String child : folderDesc.getChildren()) {
            if (handledAccountingEntries.contains(child)) {
                log.debug("Skipping remote child {} because already handled with accouting", (Object)child);
                continue;
            }
            if (handledWorkspaceItemEntries.contains(child)) {
                log.debug("Skipping remote child {} because already handled with respective item", (Object)child);
                continue;
            }
            RemoteFileDescriptor childDesc = folderController.getFileDescriptor(child);
            if (childDesc.isDirectory()) {
                handledRemoteElements.add(child);
                continue;
            }
            if (config.matchesFilter(child)) {
                log.debug("Child {} matches filter...");
                handledRemoteElements.add(child);
                if (service == null) continue;
                service.execute(new SynchronizationThread(new TransferFromThreddsRequest(ownerProcess, null, toScanItem, child)));
                log.debug("Submitted IMPORT request number {} ", (Object)ownerProcess.getStatus().getQueuedTransfers().incrementAndGet());
                continue;
            }
            log.debug("Skipping not matching remote {} ", (Object)child);
        }
        return handledRemoteElements;
    }

    static void initProperties(ItemContainer<?> toInit, String remotePath, String filter, String targetToken, String catalogName, Boolean validateMeta, String rootFolderId) throws StorageHubException {
        Metadata meta = toInit.get().getMetadata();
        Map toSetProperties = meta.getMap();
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.TO-BE-SYNCHRONIZED", "true");
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.LAST-UPDATE-TIME", "0");
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.LAST-UPDATE-STATUS", "" + (Object)((Object)StepReport.Status.OK));
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.SYNCH-STATUS", "" + (Object)((Object)SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE));
        if (toInit.getType().equals((Object)ContainerType.FOLDER)) {
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.SYNCHRONIZATION-FILTER", filter);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.REMOTE-PATH", remotePath);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.REMOTE-PERSISTENCE", "thredds");
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.TARGET-TOKEN", targetToken);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.RELATED-CATALOG", catalogName);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.VALIDATE-METADATA", "" + validateMeta);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.ROOT-FOLDER-ID", rootFolderId);
        } else {
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.METADATA-UUID", null);
        }
        meta.setMap(toSetProperties);
        toInit.setMetadata(meta);
    }

    private static void initIfMissing(Map<String, Object> current, String key, String defaultValue) {
        if (!current.containsKey(key) || current.get(key) == null || current.get(key).equals("null")) {
            current.put(key, defaultValue);
        }
    }

    static boolean isConfigured(Item toCheck) throws StorageHubException {
        return WorkspaceUtils.isConfigured(toCheck.getMetadata().getMap());
    }

    static boolean isConfigured(Map<String, Object> toCheckProperties) {
        return toCheckProperties.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED") && toCheckProperties.get("WS-SYNCH.TO-BE-SYNCHRONIZED") != null;
    }

    static SynchronizedElementInfo.SynchronizationStatus getStatusAgainstRemote(Item item, Set<String> existingRemote, ThreddsController remoteFolderController, Date lastUpdateRoutine) throws NumberFormatException, RemoteFileNotFoundException {
        String itemName = item.getName();
        SynchronizedElementInfo.SynchronizationStatus status = SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE;
        if (existingRemote.contains(itemName)) {
            Date lastUpdate;
            RemoteFileDescriptor desc = remoteFolderController.getFileDescriptor(itemName);
            Date remoteDate = new Date(desc.getLastUpdate());
            Date localDate = item.getLastModificationTime().getTime();
            if (localDate.equals(lastUpdate = WorkspaceUtils.safelyGetLastUpdate(item))) {
                status = remoteDate.after(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_WS : SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE;
            } else if (remoteDate.before(localDate)) {
                status = WorkspaceUtils.isModifiedAfter(item, lastUpdateRoutine) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE : SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE;
            } else if (remoteDate.after(localDate)) {
                status = remoteDate.equals(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE : (remoteDate.before(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE : SynchronizedElementInfo.SynchronizationStatus.OUTDATED_WS);
            }
        }
        return status;
    }

    static Date safelyGetLastUpdate(Item item) {
        try {
            return new Date(Long.parseLong("" + item.getMetadata().getMap().get("WS-SYNCH.LAST-UPDATE-TIME")));
        }
        catch (NumberFormatException e) {
            log.debug("Unable to get last update time for {} ", (Object)item.getName(), (Object)e);
            return new Date(0L);
        }
    }

    public static boolean isModifiedAfter(Item item, Date fromDate) {
        return item.getLastModificationTime().after(fromDate);
    }

    static void cleanItem(ItemContainer<?> itemContainer) throws StorageHubException {
        Metadata meta = itemContainer.get().getMetadata();
        Map<String, Object> map = meta.getMap();
        if (map.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED")) {
            if (itemContainer.getType().equals((Object)ContainerType.FOLDER)) {
                map = Constants.cleanedFolderPropertiesMap;
                for (ItemContainer child : ((FolderContainer)itemContainer).list().withMetadata().getContainers()) {
                    WorkspaceUtils.cleanItem(child);
                }
            } else {
                map = Constants.cleanedItemPropertiesMap;
            }
            meta.setMap(map);
            log.debug("Setting meta to item " + itemContainer.getId() + " : " + itemContainer.get().getPath());
            itemContainer.setMetadata(meta);
        }
    }

    static void setLastUpdateTime(FolderContainer folder, long toSetTime) throws StorageHubException {
        Metadata meta = ((FolderItem)folder.get()).getMetadata();
        Map map = meta.getMap();
        StepReport.Status currentWSStatus = StepReport.Status.valueOf("" + map.get("WS-SYNCH.LAST-UPDATE-STATUS"));
        if (currentWSStatus.equals((Object)StepReport.Status.OK)) {
            map.put("WS-SYNCH.LAST-UPDATE-TIME", String.valueOf(toSetTime));
        }
        meta.setMap(map);
        folder.setMetadata(meta);
    }

    public static SynchFolderConfiguration loadConfiguration(ItemContainer<?> item) throws StorageHubException {
        if (item.getType().equals((Object)ContainerType.FOLDER)) {
            Map map = item.get().getMetadata().getMap();
            SynchFolderConfiguration config = new SynchFolderConfiguration();
            config.setFilter("" + map.get("WS-SYNCH.SYNCHRONIZATION-FILTER"));
            config.setRemotePath("" + map.get("WS-SYNCH.REMOTE-PATH"));
            config.setRemotePersistence("" + map.get("WS-SYNCH.REMOTE-PERSISTENCE"));
            config.setTargetToken("" + map.get("WS-SYNCH.TARGET-TOKEN"));
            config.setToCreateCatalogName("" + map.get("WS-SYNCH.RELATED-CATALOG"));
            config.setValidateMetadata(Boolean.parseBoolean("" + map.get("WS-SYNCH.VALIDATE-METADATA")));
            config.setRootFolderId("" + map.get("WS-SYNCH.ROOT-FOLDER-ID"));
            return config;
        }
        FolderContainer parentFolder = WorkspaceUtils.getClient().open(item.get().getParentId()).asFolder();
        return WorkspaceUtils.loadConfiguration(parentFolder);
    }

    static void resetStatus(ItemContainer<?> item) throws StorageHubException {
        Metadata meta;
        Map map;
        if (item.getType().equals((Object)ContainerType.FOLDER)) {
            for (ItemContainer child : ((FolderContainer)item).list().withMetadata().getContainers()) {
                WorkspaceUtils.resetStatus(child);
            }
        }
        if ((map = (meta = item.get().getMetadata()).getMap()).containsKey("WS-SYNCH.LAST-UPDATE-STATUS")) {
            map.put("WS-SYNCH.LAST-UPDATE-STATUS", "" + (Object)((Object)StepReport.Status.OK));
            meta.setMap(map);
            item.setMetadata(meta);
        }
    }

    public static void addParameters(ItemContainer<?> item, Map<String, Object> toAdd) throws StorageHubException {
        Metadata meta = item.get().getMetadata();
        Map current = meta.getMap();
        current.putAll(toAdd);
        meta.setMap(current);
        item.setMetadata(meta);
    }

    public static void addParameter(ItemContainer<?> item, String key, Object value) throws StorageHubException {
        Metadata meta = item.get().getMetadata();
        Map current = meta.getMap();
        current.put(key, value);
        meta.setMap(current);
        item.setMetadata(meta);
    }

    public static ItemContainer<?> scan(FolderContainer folder, String path) throws Exception {
        String toLookFor = path.substring(path.startsWith("/") ? 1 : 0, path.length());
        String[] split = toLookFor.split("/");
        toLookFor = split[0];
        for (ItemContainer item : folder.list().withMetadata().getContainers()) {
            if (!item.get().getName().equals(toLookFor)) continue;
            if (split.length > 1) {
                return WorkspaceUtils.scan((FolderContainer)item, path.substring(toLookFor.length()));
            }
            return item;
        }
        throw new Exception("Unable to find " + path);
    }
}

