/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.model.plugins.thredds.DataSetScan;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceUtils;
import org.gcube.usecases.ws.thredds.engine.impl.threads.ProcessIdProvider;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.LockNotOwnedException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceLockedException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.SyncFolderDescriptor;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceFolderManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceFolderManager.class);
    private FolderContainer theFolder;
    private String folderId;
    private SynchFolderConfiguration config = null;
    private ThreddsController threddsController = null;
    private StorageHubClient sc;

    public static SynchronizedElementInfo getInfo(String elementId) {
        return null;
    }

    public WorkspaceFolderManager(String folderId) throws WorkspaceInteractionException {
        try {
            this.sc = WorkspaceUtils.getClient();
            this.theFolder = this.sc.open(folderId).asFolder();
            this.folderId = folderId;
        }
        catch (StorageHubException e) {
            throw new WorkspaceInteractionException("Unable to access folder id " + folderId, e);
        }
    }

    public FolderContainer getTheFolder() {
        return this.theFolder;
    }

    public ThreddsController getThreddsController() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        if (this.threddsController == null) {
            SynchFolderConfiguration config = this.getSynchConfiguration();
            this.threddsController = new ThreddsController(config.getRemotePath(), config.getTargetToken());
        }
        return this.threddsController;
    }

    private ThreddsController getRootThreddsController() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        try {
            FolderContainer root = this.sc.open(this.getSynchConfiguration().getRootFolderId()).asFolder();
            SynchFolderConfiguration rootConfig = WorkspaceUtils.loadConfiguration(root);
            return new ThreddsController(rootConfig.getRemotePath(), rootConfig.getTargetToken());
        }
        catch (StorageHubException e) {
            throw new WorkspaceInteractionException(e);
        }
    }

    public boolean isRoot() throws WorkspaceNotSynchedException, WorkspaceInteractionException {
        return this.getSynchConfiguration().getRootFolderId().equals(this.theFolder.getId());
    }

    public SynchFolderConfiguration getSynchConfiguration() throws WorkspaceInteractionException, WorkspaceNotSynchedException {
        if (this.config == null) {
            try {
                if (!this.isSynched()) {
                    throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
                }
                log.debug("Loading properties for ");
                this.config = WorkspaceUtils.loadConfiguration(this.theFolder);
            }
            catch (StorageHubException e) {
                throw new WorkspaceInteractionException("Unable to load synch configuration in " + this.folderId, e);
            }
        }
        return this.config;
    }

    public boolean isSynched() {
        Map props = ((FolderItem)this.theFolder.get()).getMetadata().getMap();
        return props.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED") && props.get("WS-SYNCH.TO-BE-SYNCHRONIZED") != null;
    }

    public SyncFolderDescriptor check(boolean recursively) throws WorkspaceInteractionException, InternalException {
        if (!this.isSynched()) {
            throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
        }
        if (this.isLocked() && !this.isLockOwned()) {
            throw new WorkspaceLockedException("Workspace " + this.folderId + " is locked.");
        }
        SynchFolderConfiguration config = this.getSynchConfiguration();
        try {
            WorkspaceFolderManager.checkFolder(this.theFolder, recursively, config, null, this.theFolder.getId(), WorkspaceUtils.safelyGetLastUpdate(this.theFolder.get()));
            return new SyncFolderDescriptor(this.folderId, ((FolderItem)this.theFolder.get()).getPath(), config);
        }
        catch (StorageHubException e) {
            throw new WorkspaceInteractionException(e);
        }
    }

    private boolean isLockOwned() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        String currentProcessId = ProcessIdProvider.instance.get();
        if (currentProcessId == null) {
            return false;
        }
        return currentProcessId.equals(this.getLockId());
    }

    public String getLockId() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        return this.getRootThreddsController().readThreddsFile("~WS-LOCK.lock");
    }

    public boolean isLocked() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        return this.getRootThreddsController().existsThreddsFile("~WS-LOCK.lock");
    }

    public void configure(SynchFolderConfiguration toSet) throws WorkspaceInteractionException, InternalException {
        if (this.isSynched()) {
            throw new WorkspaceInteractionException("Folder " + this.folderId + " is already configured for synchronization.");
        }
        log.info("Configuring folder {} as {} ", (Object)this.folderId, (Object)toSet);
        log.debug("Checking remote folder existence .. ");
        boolean createCatalog = false;
        try {
            String catalogName = toSet.getToCreateCatalogName();
            ThreddsController controller = new ThreddsController(toSet.getRemotePath(), toSet.getTargetToken());
            if (!controller.existsThreddsFile(null)) {
                log.info("Folder not found, creating it..");
                controller.createEmptyFolder(null);
                createCatalog = true;
            } else {
                ThreddsCatalog catalog = controller.getCatalog();
                if (catalog == null) {
                    createCatalog = true;
                } else {
                    log.info("Found matching catalog {} ", (Object)catalog);
                    catalogName = catalog.getTitle();
                    if (catalogName == null) {
                        catalogName = ((DataSetScan)catalog.getDeclaredDataSetScan().iterator().next()).getName();
                    }
                    toSet.setToCreateCatalogName(catalogName);
                }
            }
            if (createCatalog) {
                log.info("Creating catalog {} ", (Object)catalogName);
                log.debug("Created catalog {}", (Object)controller.createCatalog(catalogName));
            }
            WorkspaceUtils.initProperties(this.theFolder, toSet.getRemotePath(), toSet.getFilter(), toSet.getTargetToken(), toSet.getToCreateCatalogName(), toSet.getValidateMetadata(), this.theFolder.getId());
        }
        catch (InternalException e) {
            throw new InternalException("Unable to check/initialize remote folder", e);
        }
        catch (StorageHubException e) {
            throw new WorkspaceInteractionException("Unable to set Properties to " + this.folderId, e);
        }
    }

    public void dismiss(boolean deleteRemote) throws WorkspaceInteractionException, InternalException {
        if (!this.isSynched()) {
            throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
        }
        if (this.isLocked() && !this.isLockOwned()) {
            throw new WorkspaceLockedException("Workspace " + this.folderId + " is locked.");
        }
        try {
            this.cleanCache();
            WorkspaceUtils.cleanItem(this.theFolder);
            if (deleteRemote) {
                this.getThreddsController().createEmptyFolder(null);
            }
        }
        catch (StorageHubException e) {
            throw new WorkspaceInteractionException("Unable to cleanup " + this.folderId, e);
        }
    }

    public void setLastUpdateTime() throws StorageHubException {
        WorkspaceUtils.setLastUpdateTime(this.theFolder, System.currentTimeMillis());
    }

    public void forceUnlock() throws InternalException, WorkspaceInteractionException {
        try {
            this.getRootThreddsController().deleteThreddsFile("~WS-LOCK.lock");
        }
        catch (RemoteFileNotFoundException e) {
            log.debug("Forced unlock but no file found.", (Throwable)e);
        }
        catch (WorkspaceNotSynchedException e) {
            log.warn("Invoked force lock on not synched folder.", (Throwable)e);
        }
        catch (InternalException | WorkspaceInteractionException e) {
            throw e;
        }
    }

    public void lock(String processId) throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        this.getRootThreddsController().lockFolder(processId);
    }

    public void unlock() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        this.unlock(ProcessIdProvider.instance.get());
    }

    public void unlock(String processId) throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        String currentLock = this.getLockId();
        if (!processId.equals(currentLock)) {
            throw new LockNotOwnedException("Process " + processId + " can't remove lock owned by " + currentLock);
        }
        this.getRootThreddsController().deleteThreddsFile("~WS-LOCK.lock");
    }

    private void cleanCache() {
        this.config = null;
        this.threddsController = null;
    }

    private static void checkFolder(FolderContainer folder, boolean recursive, SynchFolderConfiguration rootConfig, String relativePathFromRootFolder, String rootFolderId, Date lastUpdatedRoutine) throws StorageHubException, InternalException {
        log.trace("Checking folder {} ", (Object)((FolderItem)folder.get()).getPath());
        log.debug("Configuration is {}, relativePath is {} ", (Object)rootConfig, (Object)relativePathFromRootFolder);
        String folderName = ((FolderItem)folder.get()).getName();
        String currentRemotePath = String.valueOf(rootConfig.getRemotePath()) + (relativePathFromRootFolder == null ? "" : "/" + relativePathFromRootFolder);
        ThreddsController controller = new ThreddsController(currentRemotePath, rootConfig.getTargetToken());
        HashSet<String> currentFolderExistingItem = new HashSet<String>();
        log.debug("Initializing properties for {} ", (Object)folderName);
        if (!WorkspaceUtils.isConfigured(folder.get())) {
            WorkspaceUtils.initProperties(folder, currentRemotePath, rootConfig.getFilter(), rootConfig.getTargetToken(), rootConfig.getToCreateCatalogName(), rootConfig.getValidateMetadata(), rootFolderId);
        }
        for (ItemContainer item : folder.list().withAccounting().withMetadata().getContainers()) {
            String itemName = item.get().getName();
            String itemRelativePath = relativePathFromRootFolder == null ? itemName : String.valueOf(relativePathFromRootFolder) + "/" + itemName;
            String itemRemotePath = String.valueOf(currentRemotePath) + "/" + itemName;
            if (item.getType().equals((Object)ContainerType.FOLDER)) {
                if (recursive) {
                    WorkspaceFolderManager.checkFolder((FolderContainer)item, recursive, rootConfig, itemRelativePath, rootFolderId, lastUpdatedRoutine);
                } else {
                    WorkspaceUtils.initProperties(item, itemRemotePath, rootConfig.getFilter(), rootConfig.getTargetToken(), rootConfig.getToCreateCatalogName(), rootConfig.getValidateMetadata(), rootFolderId);
                }
            } else if (rootConfig.matchesFilter(itemName) && !WorkspaceUtils.isConfigured(item.get())) {
                WorkspaceUtils.initProperties(item, null, null, null, null, null, null);
            }
            currentFolderExistingItem.add(itemName);
        }
        if (controller.existsThreddsFile(null)) {
            Set<String> toImportItems;
            SynchronizedElementInfo.SynchronizationStatus folderStatus = SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE;
            log.debug("Remote Folder {} exists. Checking status..", (Object)currentRemotePath);
            RemoteFileDescriptor folderDesc = controller.getFileDescriptor();
            HashSet<String> remoteFolderItems = new HashSet<String>(folderDesc.getChildren());
            Set<String> accountingEntries = WorkspaceUtils.scanAccountingForStatus(folder, rootConfig, currentFolderExistingItem, remoteFolderItems, controller, null, null);
            if (accountingEntries.isEmpty()) {
                log.debug("No Accounting Entries to be managed..");
                folderStatus = SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE;
            }
            for (ItemContainer item : folder.list().withAccounting().withMetadata().getContainers()) {
                if (!item.getType().equals((Object)ContainerType.FOLDER) && !rootConfig.matchesFilter(item.get().getName())) continue;
                SynchronizedElementInfo.SynchronizationStatus itemStatus = WorkspaceUtils.getStatusAgainstRemote(item.get(), remoteFolderItems, controller, lastUpdatedRoutine);
                Metadata meta = item.get().getMetadata();
                Map map = meta.getMap();
                map.put("WS-SYNCH.SYNCH-STATUS", "" + (Object)((Object)itemStatus));
                meta.setMap(map);
                item.setMetadata(meta);
                SynchronizedElementInfo.SynchronizationStatus synchronizationStatus = folderStatus = folderStatus.equals((Object)SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE) ? itemStatus : folderStatus;
            }
            if (folderStatus.equals((Object)SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE) && !(toImportItems = WorkspaceUtils.scanRemoteFolder(folderDesc, accountingEntries, currentFolderExistingItem, folder, controller, rootConfig, null, null)).isEmpty()) {
                folderStatus = SynchronizedElementInfo.SynchronizationStatus.OUTDATED_WS;
            }
            Metadata meta = ((FolderItem)folder.get()).getMetadata();
            Map map = meta.getMap();
            map.put("WS-SYNCH.SYNCH-STATUS", "" + (Object)((Object)folderStatus));
            meta.setMap(map);
            folder.setMetadata(meta);
        } else {
            for (ItemContainer item : folder.list().withMetadata().getContainers()) {
                Metadata meta = item.get().getMetadata();
                Map map = meta.getMap();
                map.put("WS-SYNCH.SYNCH-STATUS", "" + (Object)((Object)SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE));
                meta.setMap(map);
                item.setMetadata(meta);
            }
            Metadata meta = ((FolderItem)folder.get()).getMetadata();
            Map map = meta.getMap();
            map.put("WS-SYNCH.SYNCH-STATUS", "" + (Object)((Object)SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE));
            meta.setMap(map);
            folder.setMetadata(meta);
        }
    }

    public File loadCatalogFile() {
        return null;
    }

    public void updateCatalogFile(File toUpload) {
    }
}

