/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.usecases.ws.thredds.Commons;
import org.gcube.usecases.ws.thredds.FolderConfiguration;
import org.gcube.usecases.ws.thredds.NetUtils;
import org.gcube.usecases.ws.thredds.TokenSetter;
import org.gcube.usecases.ws.thredds.engine.PublishRequest;
import org.gcube.usecases.ws.thredds.engine.TransferRequestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishFolders {
    private static final Logger log = LoggerFactory.getLogger(PublishFolders.class);
    private static String WS_USER = "fabio.sinibaldi";

    public static void main(String[] args) {
        TokenSetter.set("/d4science.research-infrastructures.eu");
        HashSet<FolderConfiguration> configs = new HashSet<FolderConfiguration>();
        String folderId = "a8cd78d3-69e8-4d02-ac90-681b2d16d84d";
        String publishingUserToken = "5741e3e4-dbde-46fa-828d-88da609e0517-98187548";
        FolderConfiguration folderConfig = new FolderConfiguration(publishingUserToken, folderId, "GP_CASE");
        configs.add(folderConfig);
        TransferRequestServer server = new TransferRequestServer();
        for (FolderConfiguration entry : configs) {
            try {
                Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(WS_USER).getWorkspace();
                log.info("Managing {} ", (Object)entry);
                WorkspaceFolder folder = (WorkspaceFolder)ws.getItem(entry.getFolderId());
                PublishFolders.handleFolder(ws, entry, server, folder);
            }
            catch (WorkspaceException e) {
                System.err.println("WORKSPACE EXC ");
                e.printStackTrace(System.err);
            }
            catch (HomeNotFoundException e) {
                System.err.println("WORKSPACE EXC ");
                e.printStackTrace(System.err);
            }
            catch (InternalErrorException e) {
                System.err.println("WORKSPACE EXC ");
                e.printStackTrace(System.err);
            }
            catch (UserNotFoundException e) {
                System.err.println("WORKSPACE EXC ");
                e.printStackTrace(System.err);
            }
            catch (Exception e) {
                System.err.println("UNEXPECTED EXC");
                e.printStackTrace(System.err);
            }
        }
        System.out.println("Waiting for service.. ");
        server.waitCompletion();
        TransferRequestServer.Report report = server.getReport();
        File reportFile = report.toFile(folderConfig);
        System.out.println("Report at " + reportFile.getAbsolutePath());
    }

    public static final void handleFolder(Workspace ws, FolderConfiguration config, TransferRequestServer server, WorkspaceFolder folder) throws InternalErrorException, ItemNotFoundException {
        log.info("Handling folder {} ", (Object)folder.getPath());
        PublishFolders.cleanUpForFileRemoval(ws, folder, config.getPublishingUserToken(), config.getCatalogName());
        log.info("Folder {} cleaned up. Going to publish phase..", (Object)folder.getPath());
        PublishFolders.publishFolder(ws, config, server, folder);
    }

    public static final void publishFolder(Workspace ws, FolderConfiguration config, TransferRequestServer server, WorkspaceFolder folder) throws InternalErrorException, ItemNotFoundException {
        String toLookForName;
        File meta;
        PublishRequest req;
        String prefix;
        List folderItems = folder.getChildren();
        if (config.isIncludeSubfolders()) {
            log.info("Going through subfolders first.....");
            for (WorkspaceItem item : folderItems) {
                try {
                    if (!item.isFolder()) continue;
                    FolderConfiguration subConfig = new FolderConfiguration(config);
                    subConfig.setCatalogName(config.getCatalogName() + "/" + item.getName());
                    PublishFolders.publishFolder(ws, subConfig, server, (WorkspaceFolder)item);
                    log.debug("Subfolder {} successfully analyzed ", (Object)item.getPath());
                }
                catch (Exception e) {
                    try {
                        log.warn("Unabel to check item {} ", (Object)item.getPath(), (Object)e);
                    }
                    catch (InternalErrorException e1) {
                        log.warn("Unabel to check item and to get Path {} ", (Object)item, (Object)e);
                    }
                }
            }
        }
        log.debug("Checking for ncml files .... ");
        for (WorkspaceItem item : folderItems) {
            try {
                if (item.isFolder() || !(prefix = item.getName().substring(item.getName().lastIndexOf("."), item.getName().length())).equals(".ncml")) continue;
                req = new PublishRequest(new PublishRequest.PublishItem(item), PublishRequest.Mode.NCML, config.getCatalogName(), config.getPublishingUserToken());
                if (config.isProvidedMetadata() && (meta = PublishFolders.getMetadataForDataset(ws, toLookForName = item.getName().substring(0, item.getName().lastIndexOf(prefix)) + ".xml", config.getMetadataFolderId())) != null) {
                    req.setMetadata(meta);
                }
                server.put(req);
            }
            catch (Exception e) {
                try {
                    log.warn("Unabel to check item {} ", (Object)item.getPath(), (Object)e);
                }
                catch (InternalErrorException e1) {
                    log.warn("Unabel to check item and to get Path {} ", (Object)item, (Object)e);
                }
            }
        }
        log.debug("Checking nc files.. ");
        for (WorkspaceItem item : folder.getChildren()) {
            try {
                if (item.isFolder() || !(prefix = item.getName().substring(item.getName().lastIndexOf("."), item.getName().length())).equals(".nc")) continue;
                req = new PublishRequest(new PublishRequest.PublishItem(item), PublishRequest.Mode.NC, config.getCatalogName(), config.getPublishingUserToken());
                if (config.isProvidedMetadata() && (meta = PublishFolders.getMetadataForDataset(ws, toLookForName = item.getName().substring(0, item.getName().lastIndexOf(prefix)) + ".xml", config.getMetadataFolderId())) != null) {
                    req.setMetadata(meta);
                }
                server.put(req);
            }
            catch (Exception e) {
                try {
                    log.warn("Unabel to check item {} ", (Object)item.getPath(), (Object)e);
                }
                catch (InternalErrorException e1) {
                    log.warn("Unabel to check item and to get Path {} ", (Object)item, (Object)e);
                }
            }
        }
        folder.getProperties().addProperties(Collections.singletonMap("WS-SYNCH.LAST_UPDATE", System.currentTimeMillis() + ""));
        log.debug("Creating requests... ");
    }

    private static final File getMetadataForDataset(Workspace userWorkspace, String toLookForName, String metadataFolderId) throws WrongItemTypeException, InternalErrorException {
        try {
            WorkspaceItem found = userWorkspace.find(toLookForName, metadataFolderId);
            if (found == null) {
                throw new ItemNotFoundException("Found item was null");
            }
            return NetUtils.toFile(((ExternalFile)found).getData());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void cleanUpForFileRemoval(Workspace ws, WorkspaceFolder folder, String targetToken, String remoteFolderPath) throws InternalErrorException {
        List history = folder.getAccounting();
        long lastUpdateTimeMillis = PublishFolders.getLastUpdateTime((WorkspaceItem)folder);
        Date lastUpdate = new Date(lastUpdateTimeMillis);
        log.info("Checking history for {} (last update time {}) ", (Object)folder.getPath(), (Object)Commons.DATE_FORMAT.format(lastUpdate));
        boolean toDeleteCurrentFolder = false;
        for (AccountingEntry entry : history) {
            Date eventTime = entry.getDate().getTime();
            switch (entry.getEntryType()) {
                case REMOVAL: 
                case RENAMING: {
                    log.debug("Found Accounting Entry [type : {}, date {}] ", (Object)entry.getEntryType(), (Object)Commons.DATE_FORMAT.format(eventTime));
                    if (!eventTime.after(lastUpdate)) break;
                    log.info("Found Accounting Entry [type : {}, date {}]. Removing remote folder. ", (Object)entry.getEntryType(), (Object)Commons.DATE_FORMAT.format(eventTime));
                    toDeleteCurrentFolder = true;
                }
            }
            if (!toDeleteCurrentFolder) continue;
            break;
        }
        if (toDeleteCurrentFolder) {
            log.info("Deleting current folder {} from remote location {} ", (Object)folder.getPath(), (Object)remoteFolderPath);
            try {
                Commons.cleanupFolder(remoteFolderPath, targetToken);
                return;
            }
            catch (Throwable t) {
                log.warn("Unable To cleanup folder {} . Remote Folder might not exists. If this is first publishing ignor this.", (Object)remoteFolderPath, (Object)t);
                if (lastUpdateTimeMillis == 0L) return;
                throw t;
            }
        } else {
            log.info("Folder is not to be cleaned up. Checking children..");
            for (WorkspaceItem item : folder.getChildren()) {
                if (!item.isFolder()) continue;
                PublishFolders.cleanUpForFileRemoval(ws, (WorkspaceFolder)item, targetToken, remoteFolderPath + "/" + item.getName());
            }
        }
    }

    private static long getLastUpdateTime(WorkspaceItem item) throws InternalErrorException {
        try {
            return Long.parseLong(item.getProperties().getPropertyValue("WS-SYNCH.LAST_UPDATE"));
        }
        catch (Throwable e) {
            log.debug("Unable to get last update time for {}. Considering 0..", (Object)item.getPath());
            return 0L;
        }
    }
}

