/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.sdi.test.client;

import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilder;
import org.gcube.common.clients.ProxyBuilderImpl;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.spatia.data.model.profiles.ApplicationProfile;
import org.gcube.spatial.data.clients.SDIClientManager;
import org.gcube.spatial.data.clients.SDIGenericPlugin;
import org.gcube.spatial.data.sdi.interfaces.SDIManagement;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.w3c.dom.Node;

public class SimpleSDIManagerClient
implements SDIManagement {
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;
    private SDIClientManager clientManager = new SDIClientManager();

    public static ProxyBuilder<SDIManagement> contextService() {
        return new ProxyBuilderImpl((Plugin)new Plugin<GXWebTargetAdapterRequest, SDIManagement>(){

            public String serviceClass() {
                return "SDI";
            }

            public String serviceName() {
                return "sdi-service";
            }

            public String name() {
                return "sdi-service/gcube/service";
            }

            public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
                return fault;
            }

            public String namespace() {
                return "http://gcube-system.org/namespaces/data/sdi-service";
            }

            public GXWebTargetAdapterRequest resolve(EndpointReference epr, ProxyConfig<?, ?> config) throws Exception {
                DOMResult result = new DOMResult();
                epr.writeTo((Result)result);
                Node node = result.getNode();
                Node child = node.getFirstChild();
                String address = child.getTextContent();
                GXWebTargetAdapterRequest request = GXWebTargetAdapterRequest.newRequest((String)address).path("SDI");
                return request;
            }

            public SDIManagement newProxy(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
                return new SimpleSDIManagerClient(delegate);
            }
        }, new Property[0]);
    }

    public SimpleSDIManagerClient(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        this.delegate = delegate;
    }

    public ScopeConfiguration getConfiguration() throws RemoteException {
        Call<GXWebTargetAdapterRequest, ScopeConfiguration> call = new Call<GXWebTargetAdapterRequest, ScopeConfiguration>(){

            public ScopeConfiguration call(GXWebTargetAdapterRequest request) throws Exception {
                GXInboundResponse response = request.get();
                if (response.hasGXError() || response.getHTTPCode() < 200 || response.getHTTPCode() > 299) {
                    RemoteException e = new RemoteException("Received error response.");
                    e.setContent(response.getStreamedContentAsString());
                    e.setRemoteMessage(response.getMessage());
                    e.setResponseHTTPCode(Integer.valueOf(response.getHTTPCode()));
                    throw e;
                }
                return (ScopeConfiguration)response.tryConvertStreamedContentFromJson(ScopeConfiguration.class);
            }
        };
        try {
            return (ScopeConfiguration)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public HealthReport getReport() throws RemoteException {
        return null;
    }

    public ApplicationProfile getProfile(String serviceClass, String serviceName) throws RemoteException {
        return null;
    }

    public SDIGenericPlugin getClientByEngineId(String engineId) throws Exception {
        List desc = this.getConfiguration().getByEngine(engineId);
        if (desc == null || desc.isEmpty()) {
            throw new Exception("No " + engineId + " available in current context. Check ScopeConfiguration object.");
        }
        for (GeoServiceDescriptor d : desc) {
            SDIGenericPlugin c = this.clientManager.get(d);
            if (c == null) continue;
            return c;
        }
        throw new RuntimeException("No implementation available for " + engineId);
    }
}

