/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.RoleManager;
import org.gcube.spatial.data.sdi.engine.impl.AbstractManager;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkClient;
import org.gcube.spatial.data.sdi.engine.impl.is.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GeoNetworkManagerImpl
extends AbstractManager<GeoNetworkDescriptor, GeoNetworkServiceDefinition, GeoNetworkController>
implements GeoNetworkManager {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkManagerImpl.class);
    RoleManager roleManager;
    private GeoNetworkRetriever retriever = null;
    private GeoNetworkCluster cluster = null;

    @Inject
    public GeoNetworkManagerImpl(RoleManager roleManager) {
        this.roleManager = roleManager;
        this.retriever = new GeoNetworkRetriever();
        this.cluster = new GeoNetworkCluster(LocalConfiguration.getTTL((String)"gn.cache.TTL").longValue(), (ISModule)this.retriever, "GeoNEtwork - cache");
    }

    protected AbstractCluster<GeoNetworkDescriptor, GeoNetworkController> getCluster() {
        return this.cluster;
    }

    protected ISModule getRetriever() {
        return this.retriever;
    }

    public List<GeoNetworkDescriptor> getSuggestedInstances() throws ConfigurationNotFoundException {
        return Collections.singletonList(((GeoNetworkController)this.getCluster().getDefaultController()).getDescriptor());
    }

    public GeoNetworkClient getClient() throws ConfigurationNotFoundException {
        return this.getClient((GeoNetworkDescriptor)((GeoNetworkController)this.getCluster().getDefaultController()).getDescriptor());
    }

    public GeoNetworkClient getClient(GeoNetworkDescriptor descriptor) {
        Credentials selected = this.roleManager.getMostAccessible(descriptor.getAccessibleCredentials(), false);
        log.info("Logging in {} using {} ", (Object)descriptor, (Object)selected);
        return new GeoNetworkClient(descriptor.getBaseEndpoint(), descriptor.getVersion(), selected.getPassword(), selected.getUsername(), descriptor);
    }
}

