/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.TemplateManager;
import org.gcube.spatial.data.sdi.engine.TemporaryPersistence;
import org.gcube.spatial.data.sdi.engine.impl.faults.gn.MetadataNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkClient;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkUtils;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataHandler;
import org.gcube.spatial.data.sdi.engine.impl.metadata.TemplateApplicationReport;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateCollection;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocation;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Metadata")
@ManagedBy(value=SDIServiceManager.class)
public class Metadata {
    private static final Logger log = LoggerFactory.getLogger(Metadata.class);
    @Inject
    TemplateManager templateManager;
    @Inject
    GeoNetworkManager geonetworkManager;
    @Inject
    TemporaryPersistence persistence;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String uploadMetadata(@FormDataParam(value="theMeta") InputStream uploadedMeta, @FormDataParam(value="theMeta") FormDataContentDisposition uploadedMetaDetails) {
        try {
            log.debug("Receiving metadata upload... size {} ", (Object)uploadedMetaDetails.getSize());
            return this.persistence.store(uploadedMeta);
        }
        catch (IOException e) {
            log.error("Unable to store file. ", (Throwable)e);
            throw new WebApplicationException("Unable to store file locally. Cause : " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{uploadedId}")
    public MetadataReport applyTemplates(Collection<TemplateInvocation> templateInvocations, @PathParam(value="uploadedId") String uploadedId) {
        log.debug("Checking uploaded id {} ", (Object)uploadedId);
        File uploaded = null;
        try {
            uploaded = this.persistence.getById(uploadedId);
        }
        catch (FileNotFoundException e) {
            log.debug("Unable to ge uploaded with ID {}. Cause : ", (Object)uploadedId, (Object)e);
            throw new WebApplicationException("Invalid upload id " + uploadedId);
        }
        MetadataReport toReturn = new MetadataReport();
        HashSet<TemplateInvocation> metadataEnrichments = new HashSet<TemplateInvocation>(templateInvocations);
        if (metadataEnrichments != null && !metadataEnrichments.isEmpty()) {
            try {
                log.debug("Applying invocations...");
                TemplateApplicationReport report = this.templateManager.applyMetadataTemplates(uploaded, metadataEnrichments);
                toReturn.setAppliedTemplates(report.getAppliedTemplates());
                this.persistence.update(uploadedId, (InputStream)new FileInputStream(new File(report.getGeneratedFilePath())));
            }
            catch (Throwable e) {
                log.debug("Unable to apply templates. ", e);
                throw new WebApplicationException("Unable to apply templates. Cause : " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return toReturn;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/publish/{uploadedId}/{gnCategory}")
    public MetadataReport publishMetadata(@QueryParam(value="validate") @DefaultValue(value="true") Boolean validate, @QueryParam(value="public") @DefaultValue(value="false") Boolean makePublic, @QueryParam(value="stylesheet") @DefaultValue(value="_none_") String styleSheet, @PathParam(value="gnCategory") String category, @PathParam(value="uploadedId") String uploadedId) {
        try {
            log.debug("PUBLISHING METADATA. UPLOADED ID {} ", (Object)uploadedId);
            MetadataReport toReturn = new MetadataReport();
            File toPublish = this.persistence.getById(uploadedId);
            log.debug("Publishing metadata.. ");
            GeoNetworkDescriptor desc = (GeoNetworkDescriptor)this.geonetworkManager.getSuggestedInstances().get(0);
            GeoNetworkClient client = this.geonetworkManager.getClient(desc);
            String uuid = new MetadataHandler(toPublish).getUUID();
            long id = 0L;
            try {
                id = client.insertMetadata(category, styleSheet, validate.booleanValue(), Integer.parseInt(desc.getDefaultGroup()), makePublic.booleanValue(), toPublish);
            }
            catch (Exception e) {
                log.info("INSERT OPERATION FAILED. TRYING TO UPDATE.");
                try {
                    id = GeoNetworkUtils.getIDByUUID((GeoNetworkClient)client, (String)uuid);
                    client.updateMeta(id, toPublish);
                }
                catch (MetadataNotFoundException e1) {
                    throw new RuntimeException("Insert Operation failed with unexpected reason (Metadata with uuid " + uuid + " has not been found).", e);
                }
            }
            toReturn.setPublishedID(Long.valueOf(id));
            toReturn.setPublishedUUID(uuid);
            return toReturn;
        }
        catch (FileNotFoundException e) {
            log.warn("Unable to get uploaded with ID {}. Cause : ", (Object)uploadedId, (Object)e);
            throw new WebApplicationException("Invalid upload id " + uploadedId);
        }
        catch (Throwable e) {
            log.warn("Unexpected error while publishing {} . Cause : ", (Object)uploadedId, (Object)e);
            throw new WebApplicationException("Unabel to publish metadata. Cause " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Collection<TemplateDescriptor> getList() {
        log.debug("Received LIST method");
        TemplateCollection coll = this.templateManager.getAvailableMetadataTemplates();
        log.debug("Gonna respond with {} ", (Object)coll);
        return coll.getAvailableTemplates();
    }
}

